<?php session_start(); include('script/condb.php'); ?>
<!doctype html>
<html>
<head>
<meta charset="UTF-8">
<title>TQ Dashboard</title>
<link href="css/styles.css" rel="stylesheet" type="text/css">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
/* === COLOR PALETTE STYLES (unchanged) === */
#palette-toggle {
  position: fixed; bottom: 20px; right: 20px;
  background: #444; color: #fff;
  border: none; border-radius: 50%;
  width: 50px; height: 50px;
  font-size: 20px; cursor: pointer;
  box-shadow: 0 4px 6px rgba(0,0,0,0.2);
  z-index: 1001;
}
#palette-panel {
  position: fixed; bottom: 80px; right: 20px;
  background: #fff; border: 1px solid #ccc;
  border-radius: 12px; padding: 15px;
  width: 220px; box-shadow: 0 4px 10px rgba(0,0,0,0.3);
  display: none; z-index: 1000; cursor: default;
}
#palette-panel h4 {
  margin: 0 0 10px; font-size: 14px; text-align: center;
}
.color-swatch {
  width: 30px; height: 30px; border-radius: 50%;
  display: inline-block; margin: 5px; cursor: pointer;
  border: 2px solid transparent;
}
.color-swatch:hover { border: 2px solid #000; }
#palette-panel button,
#palette-panel select,
#palette-panel input[type=color] {
  margin-top: 10px; width: 100%; padding: 6px;
  border-radius: 6px; border: 1px solid #ccc;
  cursor: pointer;
}

/* === FONT PALETTE STYLES (isolated) === */
#font-toggle {
  position: fixed; bottom: 20px; right: 80px;
  background: #444; color: #fff;
  border: none; border-radius: 50%;
  width: 50px; height: 50px;
  font-size: 16px; cursor: pointer;
  box-shadow: 0 4px 6px rgba(0,0,0,0.2);
  z-index: 1001;
}
#font-panel {
  position: fixed; bottom: 80px; right: 80px;
  background: #fff; border: 1px solid #ccc;
  border-radius: 12px; padding: 15px;
  width: 220px; box-shadow: 0 4px 10px rgba(0,0,0,0.3);
  display: none; z-index: 1000; cursor: default;
}
#font-panel h4 {
  margin: 0 0 10px; font-size: 14px; text-align: center;
}
#font-panel select, #font-panel button {
  margin-top: 10px; width: 100%; padding: 6px;
  border-radius: 6px; border: 1px solid #ccc;
  cursor: pointer;
}
</style>
<script src="https://cdn.tailwindcss.com"></script>
<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Roboto&family=Open+Sans&family=Lobster&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Roboto&family=Open+Sans&family=Poppins&family=Lato&family=Montserrat&family=Oswald&family=Raleway&family=Ubuntu&family=Merriweather&family=Playfair+Display&family=Inter&family=Noto+Sans&family=Source+Sans+Pro&family=Nunito&family=Work+Sans&family=Karla&family=Quicksand&family=Rubik&family=Fira+Sans&family=Josefin+Sans&display=swap" rel="stylesheet">

</head>

<body>
<div class="dashboardpagewrap">
  <div class="left-frame">
    <a href="lander.php"><div class="navigations-main"><div><img src="images/home.png" width="128" height="128" alt=""/></div>Dashobard</div></a>
    <a href="settings.php"><div class="navigations-main"><div><img src="images/settings-ico.png" width="128" height="128" alt=""/></div>Settings</div></a>
  <!--  <a href="project-informations.php"><div class="navigations-main"><div><img src="images/information.png" width="128" height="128" alt=""/></div>Project Information</div></a> -->
    <a href="stagesofproject.php"><div class="navigations-main"><div><img src="images/steps.png" width="128" height="128" alt=""/></div>Stages of Project</div></a>
    <a href="#"><div class="navigations-main"><div><img src="images/control.png" width="128" height="128" alt=""/></div>Project Control</div></a>
    <a href="constructionEquipment.php"><div class="navigations-main"><div><img src="images/construction.png" width="128" height="128" alt=""/></div> Equipment</div></a>
    <a href="materials.php"><div class="navigations-main"><div><img src="images/materials.png" width="128" height="128" alt=""/></div>Materials</div></a>
    <a href="labourer.php"><div class="navigations-main"><div><img src="images/labourers.png" width="128" height="128" alt=""/></div>Labourers</div></a>
    <div class="navigations-main"><div><a href="logout.php"><img src="images/logout.png" width="128" height="128" alt=""/></a></div>Logout</div>
    <div class="logo-main"><img src="images/logo.png" width="286" height="152" alt=""/></div>
  </div>
  <div class="right-frame">
    <div class="profile-image"><img src="images/user_photo.jpg" width="160" height="160" alt=""/></div>
   
    <div class="floating-nav">
      <div class="floating-nav-nest"><span tooltip="Edit Project" flow="left"><img src="images/edit-ico.png" width="128" height="128" alt=""/></span></div>
      <div class="floating-nav-nest"><span tooltip="View Inventory" flow="left"><a href="view-mat.php"><img src="images/camera-ico.png" width="128" height="128" alt=""/></a></span></div>
      <div class="floating-nav-nest"><span tooltip="Print Project" flow="left"><a href="search.php"><img src="images/tools-ico.png" width="128" height="128" alt=""/></a></span></div>
      <div class="floating-nav-nest"><span tooltip="Share" flow="left"><img src="images/share-ico.png" width="128" height="128" alt=""/></span></div>
    </div>
     <div class="flex justify-end mb-4">
      <a href="javascript:history.back()" class="bg-blue-600 text-white px-3 py-2 rounded hover:bg-blue-700">
    ← Go Back
</a>
  </div>
    <div class="chat-bubble">
      <span tooltip="Live Chat"><img src="images/livechat-ico.png" width="128" height="128" alt=""/></span>
    </div>
  </div>
</div>

<!-- ðŸŽ¨ Color Palette -->
<button id="palette-toggle">ðŸŽ¨</button>
<div id="palette-panel">
  <h4>Customize Page</h4>
  <div>
    <div class="color-swatch" style="background:#3498db" data-color="#3498db"></div>
    <div class="color-swatch" style="background:#e74c3c" data-color="#e74c3c"></div>
    <div class="color-swatch" style="background:#2ecc71" data-color="#2ecc71"></div>
    <div class="color-swatch" style="background:#f1c40f" data-color="#f1c40f"></div>
    <div class="color-swatch" style="background:#9b59b6" data-color="#9b59b6"></div>
  </div>
  <input type="color" id="customColor">
  <select id="applyTo">
    <option value="background">Background</option>
    <option value="font">Font</option>
  </select>
  <button id="reset">Reset</button>
</div>

<!-- ðŸ”¤ Font Palette -->
<button id="font-toggle">ðŸ”¤</button>
<div id="font-panel">
  <h4>Choose Font</h4>
  <select id="fontSelector">
     <!-- System fonts -->
  <option value="Arial, sans-serif">Arial</option>
  <option value="'Times New Roman', serif">Times New Roman</option>
  <option value="Georgia, serif">Georgia</option>
  <option value="Tahoma, sans-serif">Tahoma</option>
  <option value="Verdana, sans-serif">Verdana</option>
  <option value="'Courier New', monospace">Courier New</option>
  <option value="'Trebuchet MS', sans-serif">Trebuchet MS</option>
  <option value="'Comic Sans MS', cursive">Comic Sans</option>
  
  <!-- Google Fonts -->
  <option value="'Roboto', sans-serif">Roboto</option>
  <option value="'Open Sans', sans-serif">Open Sans</option>
  <option value="'Poppins', sans-serif">Poppins</option>
  <option value="'Lato', sans-serif">Lato</option>
  <option value="'Montserrat', sans-serif">Montserrat</option>
  <option value="'Oswald', sans-serif">Oswald</option>
  <option value="'Raleway', sans-serif">Raleway</option>
  <option value="'Ubuntu', sans-serif">Ubuntu</option>
  <option value="'Merriweather', serif">Merriweather</option>
  <option value="'Playfair Display', serif">Playfair Display</option>
  <option value="'Inter', sans-serif">Inter</option>
  <option value="'Noto Sans', sans-serif">Noto Sans</option>
  <option value="'Source Sans Pro', sans-serif">Source Sans Pro</option>
  <option value="'Nunito', sans-serif">Nunito</option>
  <option value="'Work Sans', sans-serif">Work Sans</option>
  <option value="'Karla', sans-serif">Karla</option>
  <option value="'Quicksand', sans-serif">Quicksand</option>
  <option value="'Rubik', sans-serif">Rubik</option>
  <option value="'Fira Sans', sans-serif">Fira Sans</option>
  <option value="'Josefin Sans', sans-serif">Josefin Sans</option>
</select>
  <button onclick="resetFont()">Reset Font</button>
</div>

<script>
/* === COLOR PALETTE SCRIPT (your original) === */
const toggleBtn = document.getElementById("palette-toggle");
const panel = document.getElementById("palette-panel");
const swatches = document.querySelectorAll(".color-swatch");
const customColor = document.getElementById("customColor");
const applyTo = document.getElementById("applyTo");
const resetBtn = document.getElementById("reset");
toggleBtn.addEventListener("click", () => {
  panel.style.display = panel.style.display === "block" ? "none" : "block";
});
swatches.forEach(swatch => {
  swatch.addEventListener("click", () => {
    applyColor(swatch.dataset.color);
  });
});
customColor.addEventListener("input", () => {
  applyColor(customColor.value);
});
resetBtn.addEventListener("click", () => {
  document.body.style.backgroundColor = "";
  document.body.style.color = "";
  document.querySelectorAll(".navigations-main, .navigations-main a, .right-frame, .right-frame a")
    .forEach(el => { el.style.color = ""; });
  localStorage.removeItem("customization");
  localStorage.removeItem("palettePosition");
});
function applyColor(color) {
  if (applyTo.value === "background") {
    document.body.style.backgroundColor = color;
    saveCustomization("background", color);
  } else {
    document.body.style.color = color;
    document.querySelectorAll(".navigations-main, .navigations-main a, .right-frame, .right-frame a")
      .forEach(el => { el.style.color = color; });
    saveCustomization("font", color);
  }
}
function saveCustomization(type, color) {
  localStorage.setItem("customization", JSON.stringify({ type, color }));
}
window.addEventListener("load", () => {
  const saved = localStorage.getItem("customization");
  if (saved) {
    const { type, color } = JSON.parse(saved);
    if (type === "background") {
      document.body.style.backgroundColor = color;
    } else {
      document.body.style.color = color;
      document.querySelectorAll(".navigations-main, .navigations-main a, .right-frame, .right-frame a")
        .forEach(el => { el.style.color = color; });
    }
    applyTo.value = type;
  }
  const savedPos = JSON.parse(localStorage.getItem("palettePosition"));
  if (savedPos) {
    panel.style.left = savedPos.left;
    panel.style.top = savedPos.top;
    panel.style.bottom = "auto";
    panel.style.right = "auto";
  }
});
let isDragging = false, offsetX = 0, offsetY = 0;
panel.addEventListener("mousedown", (e) => {
  if (["BUTTON","SELECT","INPUT"].includes(e.target.tagName)) return;
  isDragging = true;
  offsetX = e.clientX - panel.offsetLeft;
  offsetY = e.clientY - panel.offsetTop;
  panel.style.cursor = "move";
});
document.addEventListener("mousemove", (e) => {
  if (isDragging) {
    panel.style.left = e.clientX - offsetX + "px";
    panel.style.top = e.clientY - offsetY + "px";
    panel.style.bottom = "auto";
    panel.style.right = "auto";
  }
});
document.addEventListener("mouseup", () => {
  if (isDragging) {
    isDragging = false;
    panel.style.cursor = "default";
    localStorage.setItem("palettePosition", JSON.stringify({
      left: panel.style.left, top: panel.style.top
    }));
  }
});

/* === FONT PALETTE SCRIPT (new, isolated) === */
const fontToggle = document.getElementById("font-toggle");
const fontPanel = document.getElementById("font-panel");
const fontSelector = document.getElementById("fontSelector");

fontToggle.addEventListener("click", () => {
  fontPanel.style.display = fontPanel.style.display === "block" ? "none" : "block";
});

fontSelector.addEventListener("change", () => {
  document.body.style.fontFamily = fontSelector.value;
  localStorage.setItem("selectedFont", fontSelector.value);
});

function resetFont() {
  document.body.style.fontFamily = "";
  localStorage.removeItem("selectedFont");
  fontSelector.value = "Arial, sans-serif";
}

window.addEventListener("load", () => {
  const savedFont = localStorage.getItem("selectedFont");
  if (savedFont) {
    document.body.style.fontFamily = savedFont;
    fontSelector.value = savedFont;
  }
});

/* draggable font panel */
(function dragElement(elmnt){
  let pos1=0,pos2=0,pos3=0,pos4=0;
  elmnt.onmousedown = dragMouseDown;
  function dragMouseDown(e){
    if (["BUTTON","SELECT","INPUT"].includes(e.target.tagName)) return;
    e.preventDefault();
    pos3 = e.clientX; pos4 = e.clientY;
    document.onmouseup = closeDragElement;
    document.onmousemove = elementDrag;
  }
  function elementDrag(e){
    e.preventDefault();
    pos1 = pos3 - e.clientX;
    pos2 = pos4 - e.clientY;
    pos3 = e.clientX;
    pos4 = e.clientY;
    elmnt.style.top = (elmnt.offsetTop - pos2) + "px";
    elmnt.style.left = (elmnt.offsetLeft - pos1) + "px";
  }
  function closeDragElement(){
    document.onmouseup = null;
    document.onmousemove = null;
  }
})(fontPanel);
</script>
</body>
</html>
