
<?php
$sections = ['Materials', 'Labours', 'Equipments'];
$totalFinal = 0;
foreach ($sections as $section) {
    echo '<table class="w-full text-sm text-left border border-gray-300">';
    echo '<thead class="bg-gray-200 text-gray-700">';
    echo '<tr>';
    echo '<th class="border px-2 py-1">Item</th>';
    echo '<th class="border px-2 py-1">Description</th>';
    echo '<th class="border px-2 py-1">Quantity</th>';
    echo '<th class="border px-2 py-1">Extra</th>';
    echo '<th class="border px-2 py-1">Price</th>';
    echo '<th class="border px-2 py-1">Total Amount</th>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $rows = 5;
    $sectionTotal = 0;
    for ($i = 1; $i <= $rows; $i++) {
        $desc = "$section Item $i";
        $qty = rand(1, 10);
        $extra = rand(0, 5);
        $price = rand(100, 500);
        $total = ($qty + $extra) * $price;
        $sectionTotal += $total;
        echo '<tr>';
        echo "<td class='border px-2 py-1'>$i</td>";
        echo "<td class='border px-2 py-1'>$desc</td>";
        echo "<td class='border px-2 py-1'>$qty</td>";
        echo "<td class='border px-2 py-1'>$extra</td>";
        echo "<td class='border px-2 py-1'>$price</td>";
        echo "<td class='border px-2 py-1'>".number_format($total,2)."</td>";
        echo '</tr>';
    }

    $contingency = $sectionTotal * 0.05;
    $grandSection = $sectionTotal + $contingency;
    $totalFinal += $grandSection;

    echo "<tr><td colspan='5' class='border px-2 py-1 text-right font-semibold'>Contingency 5%</td><td class='border px-2 py-1 text-red-600'>".number_format($contingency,2)."</td></tr>";
    echo "<tr><td colspan='5' class='border px-2 py-1 text-right font-bold'>TOTAL</td><td class='border px-2 py-1 font-bold'>".number_format($grandSection,2)."</td></tr>";
    echo '</tbody>';
    echo '</table><br>';
}

echo "<div class='text-right text-xl font-bold mt-4 text-blue-700'>FOUNDATION TOTAL: NGN ".number_format($totalFinal,2)."</div>";
?>
