
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Foundation Report</title>
    <script src="https://cdn.jsdelivr.net/npm/xlsx@0.18.5/dist/xlsx.full.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100 p-8">

    <div class="max-w-7xl mx-auto bg-white p-6 shadow rounded">
        <h1 class="text-2xl font-bold mb-4 text-center">Foundation Report</h1>
        <div class="flex justify-end gap-4 mb-4">
            <button onclick="exportToExcel()" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">Export to Excel</button>
            <button onclick="exportToPDF()" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Export to PDF</button>
        </div>

        <div id="report-content" class="space-y-10">
            <?php include('foundation_data.php'); ?>
        </div>
    </div>

    <script>
        function exportToExcel() {
            var wb = XLSX.utils.table_to_book(document.querySelector('table'), {sheet: "Report"});
            XLSX.writeFile(wb, 'foundation_report.xlsx');
        }

        function exportToPDF() {
            const { jsPDF } = window.jspdf;
            const reportContent = document.getElementById('report-content');
            html2canvas(reportContent).then(canvas => {
                const imgData = canvas.toDataURL('image/png');
                const pdf = new jsPDF('p', 'mm', 'a4');
                const pageWidth = pdf.internal.pageSize.getWidth();
                const pageHeight = pdf.internal.pageSize.getHeight();
                const ratio = canvas.height / canvas.width;
                const imgHeight = pageWidth * ratio;
                pdf.addImage(imgData, 'PNG', 0, 0, pageWidth, imgHeight);
                pdf.save('foundation_report.pdf');
            });
        }
    </script>
</body>
</html>
