<!-- foundation_copping.php -->
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Foundation Copping & Plinth Beams</title>
<style>
  :root{
    --bg:#e5edf7;
    --card:#9cb7d3;
    --panel:#b8c7d9;
    --panel-2:#d7e2ef;
    --accent:#103049;
  }
  body{margin:0;background:var(--bg);font-family:Arial, sans-serif}
  .container{width:100%;margin:20px auto;background:var(--card);padding:18px;border-radius:6px;}
  h2{color:var(--accent);text-align:center;margin:4px 0 14px 0}
  .group-header{width:100%;background:#f7c4c4;color:#4a0000;font-weight:bold;text-align:center;padding:6px 0;margin:10px 0;border-radius:4px;font-size:16px;}
  .section{background:var(--panel);padding:8px;margin-bottom:14px;border-radius:4px;display:flex;flex-direction:column;gap:8px;border-left:4px solid #f4d03f;}
  .section-title{font-weight:bold;color:var(--accent);display:flex;align-items:center;gap:8px;}
  .row{display:flex;align-items:center;gap:6px;width:100%;}
  .row label{width:90px;color:#1b3647;font-size:13px;}
  .row input, .row select{padding:4px 6px;border-radius:4px;border:1px solid #999;background:var(--panel-2);}
  hr{border:0;border-top:2px solid #7a8ca3;margin:14px 0;}
</style>
</head>
<body>
<div class="container">

  <h2>Foundation Copping & Plinth Beams</h2>

  <div class="group-header">Properties</div>

  <!-- Walls -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Calculate Walls</div>

    <div class="row">
      <label>Exterior Walls</label>
      <input type="text" placeholder="Wall Size">
      <input type="text" placeholder="Length">
    </div>

    <div class="row">
      <label>Interior Walls</label>
      <input type="text" placeholder="Wall Size">
      <input type="text" placeholder="Length">
    </div>

    <div class="row">
      <label>Other Interior Walls</label>
      <input type="text" placeholder="Wall Size">
      <input type="text" placeholder="Length">
    </div>
  </div>

  <!-- Planks -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Calculate Planks</div>

    <div class="row">
      <label>Plank Type</label>
      <select>
        <option>1" × 12" × 12'</option>
        <option>1" × 9" × 12'</option>
      </select>
    </div>
  </div>

  <!-- Woods -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Calculate Woods</div>

    <div class="row">
      <label>Exterior Walls</label>
      <input type="text" placeholder="Spacing">
      <select><option>2" × 2" × 12' Wood</option></select>
    </div>

    <div class="row">
      <label>Interior Walls</label>
      <input type="text" placeholder="Spacing">
      <select><option>2" × 2" × 12' Wood</option></select>
    </div>

    <div class="row">
      <label>Other Interior Walls</label>
      <input type="text" placeholder="Spacing">
      <select><option>2" × 2" × 12' Wood</option></select>
    </div>
  </div>

  <!-- Stirrups -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Calculate Stirrups</div>

    <div class="row">
      <label>Exterior Walls</label>
      <input type="text" placeholder="Spacing">
      <select><option>8mm Steel</option></select>
    </div>

    <div class="row">
      <label>Interior Walls</label>
      <input type="text" placeholder="Spacing">
      <select><option>8mm Steel</option></select>
    </div>

    <div class="row">
      <label>Other Interior Walls</label>
      <input type="text" placeholder="Spacing">
      <select><option>8mm Steel</option></select>
    </div>
  </div>

  <!-- Bars -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Calculate Bars</div>

    <div class="row" style="font-weight:bold;color:#103049;">Bars for Exterior Walls</div>

    <div class="row">
      <label>Top Bars</label>
      <input type="text" placeholder="Count">
      <select><option>12mm Steel</option></select>
    </div>

    <div class="row">
      <label>Bottom Bars</label>
      <input type="text" placeholder="Count">
      <select><option>12mm Steel</option></select>
    </div>

    <div class="row" style="font-weight:bold;color:#103049;margin-top:10px;">Bars for Interior Walls</div>

    <div class="row">
      <label>Top Bars</label>
      <input type="text" placeholder="Count">
      <select><option>12mm Steel</option></select>
    </div>

    <div class="row">
      <label>Bottom Bars</label>
      <input type="text" placeholder="Count">
      <select><option>12mm Steel</option></select>
    </div>

  </div>

  <!-- Concrete -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Calculate Concretes</div>

    <div class="row">
      <label>Exterior Walls</label>
      <input type="text" placeholder="Thickness">
      <select><option>M12</option></select>
      <label>Cement</label><input type="text" placeholder="Bags" style="width:60px;">
      <label>Sand</label><input type="text" placeholder="m³" style="width:60px;">
      <label>Gravel</label><input type="text" placeholder="m³" style="width:60px;">
    </div>

    <div class="row">
      <label>Interior Walls</label>
      <input type="text" placeholder="Thickness">
      <select><option>M12</option></select>
      <label>Cement</label><input type="text" placeholder="Bags" style="width:60px;">
      <label>Sand</label><input type="text" placeholder="m³" style="width:60px;">
      <label>Gravel</label><input type="text" placeholder="m³" style="width:60px;">
    </div>

    <div class="row">
      <label>Other Walls</label>
      <input type="text" placeholder="Thickness">
      <select><option>M12</option></select>
      <label>Cement</label><input type="text" placeholder="Bags" style="width:60px;">
      <label>Sand</label><input type="text" placeholder="m³" style="width:60px;">
      <label>Gravel</label><input type="text" placeholder="m³" style="width:60px;">
    </div>
  </div>

  <!-- Extra Bars -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Bars For Extra Works</div>

    <div class="row">
      <label>8mm Steel</label>
      <input type="text" placeholder="Qty">
    </div>
    <div class="row">
      <label>10mm Steel</label>
      <input type="text" placeholder="Qty">
    </div>
    <div class="row">
      <label>12mm Steel</label>
      <input type="text" placeholder="Qty">
    </div>
  </div>

  <!-- Plumbing -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Plumbing Piping</div>

    <div class="row">
      <label>Materials</label>
      <input type="text" placeholder="Cost">
      <label>Labour</label>
      <input type="text" placeholder="Cost">
    </div>
  </div>

  <!-- Electrical -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Electrical Piping</div>

    <div class="row">
      <label>Materials</label>
      <input type="text" placeholder="Cost">
      <label>Labour</label>
      <input type="text" placeholder="Cost">
    </div>
  </div>

  <!-- Equipments -->
  <div class="section">
    <div class="section-title"><input type="checkbox"> Equipments to be Used</div>

    <div class="row">
      <label>Number</label>
      <input type="number" placeholder="0">
      <label>Name</label>
      <select>
        <option>Leveling Instrument</option>
        <option>Dozer</option>
        <option>Excavator</option>
        <option>Compactor Machine</option>
        <option>Self Loading Mixer Truck</option>
        <option>Concrete Mixer</option>
        <option>Poker Vibration Machine</option>
        <option>Water Pump & Hose</option>
        <option>Roller Compactor</option>
      </select>
    </div>

    <div class="row">
      <label>Number</label>
      <input type="number" placeholder="0">
      <label>Name</label>
      <select>
        <option>Leveling Instrument</option>
        <option>Dozer</option>
        <option>Excavator</option>
        <option>Compactor Machine</option>
        <option>Self Loading Mixer Truck</option>
        <option>Concrete Mixer</option>
        <option>Poker Vibration Machine</option>
        <option>Water Pump & Hose</option>
        <option>Roller Compactor</option>
      </select>
    </div>

    <div class="row">
      <label>Number</label>
      <input type="number" placeholder="0">
      <label>Name</label>
      <select>
        <option>Leveling Instrument</option>
        <option>Dozer</option>
        <option>Excavator</option>
        <option>Compactor Machine</option>
        <option>Self Loading Mixer Truck</option>
        <option>Concrete Mixer</option>
        <option>Poker Vibration Machine</option>
        <option>Water Pump & Hose</option>
        <option>Roller Compactor</option>
      </select>
    </div>

  </div>

</body>
</html>
