<?php
session_start();
include('script/condb.php'); // DB connection

// Optional: capture project_ref if passed
$PID = $_GET['project_ref'] ?? $_POST['pid'] ?? $_SESSION['pid'] ?? '';
if (!empty($PID)) {
    $_SESSION['pid'] = $PID;
}

/* Pre-build options for JS templates (equipment only) */
$equipmentOptions = '';
$prod_eq = "SELECT construction_equipmentName FROM upline_app_construction_equipment";
$que_eq = mysqli_query($con, $prod_eq);
while ($rec_eq = mysqli_fetch_assoc($que_eq)) {
    $name = htmlspecialchars($rec_eq['construction_equipmentName']);
    $equipmentOptions .= '<option value="'.$name.'">'.$name.'</option>';
}

//----------------------block fromDB----------------------------
$blockOptions = "";
$prod = "SELECT Block_name FROM upline_app_blocksettings";
$que2 = mysqli_query($con, $prod);
while($rec2 = mysqli_fetch_array($que2)){
    $blockOptions .= '<option value="'.$rec2['Block_name'].'">'.$rec2['Block_name'].'</option>';
}

//--------------------------Planks from DB----------------------
$plankOptions = "";
$prod_plank = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='plank'";
$que_plank = mysqli_query($con, $prod_plank);
while($rec_plank = mysqli_fetch_array($que_plank)){
    $plankOptions .= '<option value="'.$rec_plank['plankothers_name'].'">'.$rec_plank['plankothers_name'].'</option>';
}

//--------------------------woods from DB----------------------
$woodOptions ="";
$prod_wood = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='wood'";
$que_wood = mysqli_query($con, $prod_wood);
while($rec_wood = mysqli_fetch_array($que_wood)){
   $woodOptions .= '<option value="'.$rec_wood['plankothers_name'].'">'.$rec_wood['plankothers_name'].'</option>';
}

//--------------steel from DB----------------------------
$steelOptions ="";
$prod_steel = "SELECT steels_wire_name FROM upline_app_steels_wire WHERE steels_wire_type='steel'";
$que_steel = mysqli_query($con, $prod_steel);
while($rec_steel = mysqli_fetch_array($que_steel)){
   $steelOptions .= '<option value="'.$rec_steel['steels_wire_name'].'">'.$rec_steel['steels_wire_name'].'</option>';
}

//------------------------------Concete from DB-----
$concreteOptions ="";
$prod_con1 = "SELECT Mixed_Ratio_Name FROM upline_app_concretework";
$que_con1 = mysqli_query($con, $prod_con1);
while($rec_con1 = mysqli_fetch_array($que_con1)){
    $concreteOptions .= '<option value="'.$rec_con1['Mixed_Ratio_Name'].'">'.$rec_con1['Mixed_Ratio_Name'].'</option>';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Foundation Copping</title>
<link rel="stylesheet" href="foundation.css">
</head>
<body class="foundation-body">

<div class="container">
  <div class="section-top-title">
    FOUNDATION COPPING
  </div>

  <!-- === 1. Walls === -->
<div class="section">

  <!-- HEADER -->
  <div class="flex-between mb-4">
      <!-- Main Walls Checkbox -->
      <label class="checkbox-label m-0">
          <input type="checkbox">
          <span class="text-red">Walls</span>
      </label>
  </div>

  <!-- TOP LABELS -->
  <div class="header-row" style="display:flex;gap:6px;margin-bottom:4px;
                                  font-size:13px;font-weight:bold;color:#103049;">
      <!-- First column is for the checkbox + wall name -->
      <div style="width:160px;"></div>
      <div style="width:80px;">Length</div>
      <div style="width:80px;">Course</div>
  </div>

  <!-- Exterior -->
  <div class="row" style="display:flex;gap:6px;margin-bottom:4px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
          <input type="checkbox" style="margin-right:6px;">
          <span style="font-size:12px;">Exterior Walls</span>
      </label>

      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
      <input type="text" placeholder="Course" class="wall-input" style="width:80px;">
  </div>

  <!-- Interior -->
  <div class="row" style="display:flex;gap:6px;margin-bottom:4px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
          <input type="checkbox" style="margin-right:6px;">
          <span style="font-size:12px;">Interior Walls</span>
      </label>

      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
      <input type="text" placeholder="Course" class="wall-input" style="width:80px;">
  </div>

  <!-- Other Interior -->
  <div class="row" style="display:flex;gap:6px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
          <input type="checkbox" style="margin-right:6px;">
          <span style="font-size:12px;">Other Interior</span>
      </label>

      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
      <input type="text" placeholder="Course" class="wall-input" style="width:80px;">
  </div>

</div>

  <div class="section-top-title" style="margin:10px 0 10px 0;">PROPERTIES</div>
  
   <!-- === 5. Planks === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Planks</span></label>
    </div>

   <div class="row" style="display:flex; align-items:center; gap:12px; margin-bottom:12px;">

    <!-- Checkbox + Label -->
    <label style="display:flex; align-items:center; gap:6px; font-size:12px; color:#0047b3; font-weight:bold; user-select:none;">
        <input type="checkbox" style="transform:scale(0.9); margin:0;">
        Plank for column bases
    </label>

    <!-- Select Box (Same Line) -->
    <select class="cbase-select" 
            style="width:200px; height:24px; padding:3px 6px; background:#f7f7f7; border:1px solid #7f9bbd; border-radius:4px;">
        <?php echo $plankOptions; ?>
    </select>

</div>

  </div>
 <!-- === 6. Woods === -->
  <div class="section">
    <div class="flex-row align-center gap-25 mb-4">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Woods</span></label>
    </div>

    <div class="text-italic-white" style="margin-bottom:8px;">Wood for Kicker</div>

   <!-- TOP LABELS -->
  <div class="header-row" style="display:flex;gap:6px;margin-bottom:4px;
                                  font-size:13px;font-weight:bold;color:#103049;">
      <!-- First column is for the checkbox + wall name -->
      <div style="width:160px;"></div>
      <div style="width:80px;">Spacing</div>
      <div style="width:120px;">Wood Type</div>
  </div>

  <!-- Exterior -->
  <div class="row" style="display:flex;gap:6px;margin-bottom:4px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
         <!--  <input type="checkbox" style="margin-right:6px;"> -->
          <span style="font-size:12px;">Exterior Walls</span>
      </label>

      <input type="text" placeholder="Wood Spacing" class="wall-input" style="width:80px;">
      <select class="cbase-select w-120"><?php echo $woodOptions; ?></select>
  </div>

  <!-- Interior -->
  <div class="row" style="display:flex;gap:6px;margin-bottom:4px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
        <!--   <input type="checkbox" style="margin-right:6px;">-->
          <span style="font-size:12px;">Interior Walls</span>
      </label>

      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
      <select class="cbase-select w-120"><?php echo $woodOptions; ?></select>
  </div>

  <!-- Other Interior -->
  <div class="row" style="display:flex;gap:6px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
        <!--   <input type="checkbox" style="margin-right:6px;">-->
          <span style="font-size:12px;">Other Interior</span>
      </label>

      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
<select class="cbase-select w-120"><?php echo $woodOptions; ?></select>  </div>
  </div>


  <!-- === 3. Partition in Trench 
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Partitions in Trench</span></label>
    </div>

    <div class="row" style="align-items:flex-start; margin-bottom:10px;">
      <div class="flex-column">
        <label class="label-strong mb-2">Length</label>
        <input class="partition-input w-120" type="text" placeholder="Length">
      </div>
      <div class="flex-column">
        <label class="label-strong mb-2">Width</label>
        <input class="partition-input w-120" type="text" placeholder="Width">
      </div>
      <div class="flex-column">
        <label class="label-strong mb-2">Depth</label>
        <input class="partition-input w-120" type="text" placeholder="Depth">
      </div>
    </div>
  </div>=== -->

  <!-- === 4. Blocks & Mortar 
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Blocks & Mortars</span></label>
    </div>

    <div style="font-size:13px;color:white;font-weight:bold;font-style:italic;margin-bottom:6px;user-select:none;">
        Cement Mortar Ratio
    </div>

    <div class="flex-row gap-6 mb-2">
        <div class="flex-column">
            <label class="label-strong mb-2">Cement</label>
            <input type="text" class="cbase-input w-120" placeholder="Cement">
        </div>
        <div class="flex-column">
            <label class="label-strong mb-2">Sand</label>
            <input type="text" class="cbase-input w-120" placeholder="Sand">
        </div>
    </div>
  </div>=== -->

 
 
  <!-- === 7. Stirrups === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label" style="margin-top:10px;"><input type="checkbox"><span class="text-red">Stirrups</span></label>
    </div>
    <!-- TOP LABELS -->
  <div class="header-row" style="display:flex;gap:6px;margin-bottom:4px;
                                  font-size:13px;font-weight:bold;color:#103049;">
      <!-- First column is for the checkbox + wall name -->
      <div style="width:160px;"></div>
      <div style="width:80px;">Spacing</div>
      <div style="width:120px;">Bar Type</div>
  </div>

  <!-- Exterior -->
  <div class="row" style="display:flex;gap:6px;margin-bottom:4px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
         <!--  <input type="checkbox" style="margin-right:6px;"> -->
          <span style="font-size:12px;">Exterior Walls</span>
      </label>

      <input type="text" placeholder="Wood Spacing" class="wall-input" style="width:80px;">
      <select class="cbase-select w-120"><?php echo $steelOptions; ?></select>
  </div>

  <!-- Interior -->
  <div class="row" style="display:flex;gap:6px;margin-bottom:4px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
        <!--   <input type="checkbox" style="margin-right:6px;">-->
          <span style="font-size:12px;">Interior Walls</span>
      </label>

      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
      <select class="cbase-select w-120"><?php echo $steelOptions; ?></select>
  </div>

  <!-- Other Interior -->
  <div class="row" style="display:flex;gap:6px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
        <!--   <input type="checkbox" style="margin-right:6px;">-->
          <span style="font-size:12px;">Other Interior</span>
      </label>

      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
<select class="cbase-select w-120"><?php echo $steelOptions; ?></select>  </div>
  </div>

  <!-- === 8. Bars === -->
  <div class="section">
    <div class="pos-relative" style="margin-top:10px;">
        <label class="pos-abs-left-0 checkbox-label"><input type="checkbox"><span class="text-red">Bars</span></label>
     <!--   <label class="pos-abs-left-126 checkbox-label"><input type="checkbox" style="transform:scale(0.85);"><span class="label-blue">Bars for Column Bases</span></label>
        <label class="pos-abs-left-292 checkbox-label"><input type="checkbox" style="transform:scale(0.85);"><span class="label-blue">Bars for Entire Columns</span></label>-->
    </div>
    <div class="text-italic-white" style="margin-bottom:8px;">Bars For Exterior Walls</div>
     <!-- ========================================================== -->
    <!-- 2) BARS FOR GROUND BEAMS -->
    <!-- ========================================================== -->

    

    <!-- LABELS -->
    <!-- LABELS ROW (Perfectly aligned above input fields) -->
<div style="
    display:flex;
    align-items:center;
    gap:6px;
    font-size:12px;
    color:#103049;
    font-weight:bold;
    margin-bottom:4px;
">

    <!-- Spacer to align over "Top Bars" label -->
    <div style="width:80px;"></div>

    <!-- Numbers -->
    <div style="width:70px; text-align:left;">Numbers</div>

    <!-- Bar Types -->
    <div style="width:120px; text-align:left;">Bar Types</div>
</div>


<!-- TOP BARS ROW -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:6px;">

    <!-- Row Label -->
    <span style="width:80px;font-size:12px;color:#103049;">Top Bars</span>

    <!-- Numbers Input -->
    <input type="text" value="5"
           style="width:70px;height:24px;padding:4px 6px;
                  border:1px solid #7f9bbd;border-radius:4px;
                  box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                  font-size:14px;">

    <!-- Bar Types Dropdown -->
    <select style="width:120px;height:24px;padding:4px 6px;
                   color:#777;background:#f7f7f7;
                   border:1px solid #7f9bbd;border-radius:4px;
                   font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>

</div>


    <!-- BOTTOM BARS -->
    <div style="display:flex;align-items:center;gap:6px;margin-bottom:16px;">
        <span style="width:80px;font-size:12px;color:#103049;">Bottom Bars</span>
        <input type="text" value="5" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select style="width:120px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>
     <div class="text-italic-white" style="margin-bottom:8px;">Bars For Interior Walls</div>
     <!-- TOP BARS ROW -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:6px;">

    <!-- Row Label -->
    <span style="width:80px;font-size:12px;color:#103049;">Top Bars</span>

    <!-- Numbers Input -->
    <input type="text" value="5"
           style="width:70px;height:24px;padding:4px 6px;
                  border:1px solid #7f9bbd;border-radius:4px;
                  box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                  font-size:14px;">

    <!-- Bar Types Dropdown -->
    <select style="width:120px;height:24px;padding:4px 6px;
                   color:#777;background:#f7f7f7;
                   border:1px solid #7f9bbd;border-radius:4px;
                   font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>

</div>


    <!-- BOTTOM BARS -->
    <div style="display:flex;align-items:center;gap:6px;margin-bottom:16px;">
        <span style="width:80px;font-size:12px;color:#103049;">Bottom Bars</span>
        <input type="text" value="5" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select style="width:120px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>
    
      <div class="text-italic-white" style="margin-bottom:8px;">Bars For Other Interior Walls</div>
     <!-- TOP BARS ROW -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:6px;">

    <!-- Row Label -->
    <span style="width:80px;font-size:12px;color:#103049;">Top Bars</span>

    <!-- Numbers Input -->
    <input type="text" value="5"
           style="width:70px;height:24px;padding:4px 6px;
                  border:1px solid #7f9bbd;border-radius:4px;
                  box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                  font-size:14px;">

    <!-- Bar Types Dropdown -->
    <select style="width:120px;height:24px;padding:4px 6px;
                   color:#777;background:#f7f7f7;
                   border:1px solid #7f9bbd;border-radius:4px;
                   font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>

</div>


    <!-- BOTTOM BARS -->
    <div style="display:flex;align-items:center;gap:6px;margin-bottom:16px;">
        <span style="width:80px;font-size:12px;color:#103049;">Bottom Bars</span>
        <input type="text" value="5" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select style="width:120px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>
  </div>

  <!-- === 9. Concrete === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Concretes</span></label>
        
    </div>

    
  
   <!-- TOP LABELS -->
  <div class="header-row" style="display:flex;gap:6px;margin-bottom:4px;
                                  font-size:13px;font-weight:bold;color:#103049;">
      <!-- First column is for the checkbox + wall name -->
      <div style="width:160px;"></div>
      <div style="width:80px;">Thickness</div>
      <div style="width:120px;">Concrete Grade</div>
      <div class="w-80">Cement</div>
      <div class="w-80">Sand</div>
      <div class="w-80">Gravel</div>
  </div>

  <!-- Exterior -->
  <div class="row" style="display:flex;gap:6px;margin-bottom:4px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
         <!--  <input type="checkbox" style="margin-right:6px;"> -->
          <span style="font-size:12px;">Exterior Walls</span>
      </label>

      <input type="text" placeholder="Wood Spacing" class="wall-input" style="width:80px;">
     
  </div>

  <!-- Interior -->
  <div class="row" style="display:flex;gap:6px;margin-bottom:4px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
        <!--   <input type="checkbox" style="margin-right:6px;">-->
          <span style="font-size:12px;">Interior Walls</span>
      </label>

      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
      <select class="cbase-select w-120"><?php echo $concreteOptions;; ?></select>
      <input type="text" class="cbase-input w-80" placeholder="Cement">
        <input type="text" class="cbase-input w-80" placeholder="Sand">
        <input type="text" class="cbase-input w-80" placeholder="Gravel">
  </div>

  <!-- Other Interior -->
  <div class="row" style="display:flex;gap:6px;align-items:center;">
      <label style="display:flex;align-items:center;width:160px;">
        <!--   <input type="checkbox" style="margin-right:6px;">-->
          <span style="font-size:12px;">Other Interior</span>
      </label>

      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">

  
  </div>
    
  </div>

  <!-- === 10. Imported Bars === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Imported Bars</span></label>
    </div>

    <div class="header-row">
        <div class="w-120">Bar Type</div>
        <div class="w-120">Total Length</div>
        <div class="w-120">Bar Quantity</div>
    </div>

    <div id="importedBarsContainer">
      <div class="row imported-bar-row align-center mb-10">
          <select class="cbase-select w-120"><?php echo $steelOptions; ?></select>
          <input type="text" class="cbase-input w-120" placeholder="Total Length">
          <input type="text" class="cbase-input w-120" placeholder="Bar Quantity">
      </div>
    </div>

    <button type="button" onclick="addImportedBarRow()" class="btn-add">+ Add More</button>
  </div>

  <!-- === 11. Plumbing === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Plumbing Piping</span></label>
    </div>

    <div class="header-row">
        <div class="w-120">Materials</div>
        <div class="w-120">Labour</div>
    </div>

    <div class="row">
        <input type="text" class="cbase-input w-120" placeholder="Materials">
        <input type="text" class="cbase-input w-120" placeholder="Labour">
    </div>
  </div>

  <!-- === 12. Electrical === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Electrical Piping</span></label>
    </div>

    <div class="header-row">
        <div class="w-120">Materials</div>
        <div class="w-120">Labour</div>
    </div>

    <div class="row">
        <input type="text" class="cbase-input w-120" placeholder="Materials">
        <input type="text" class="cbase-input w-120" placeholder="Labour">
    </div>
  </div>

  <!-- === 13. Equipments === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Equipments</span></label>
    </div>

    <div class="header-row">
        <div class="w-246">Equipment</div>
        <div class="w-120">Quantity</div>
    </div>

    <div id="equipmentContainer">
      <div class="row equipment-row mb-10 align-center">
          <select class="cbase-select w-246"><?php echo $equipmentOptions; ?></select>
          <input type="text" class="cbase-input w-120" placeholder="Quantity">
      </div>
    </div>

    <button type="button" onclick="addEquipmentRow()" class="btn-add">+ Add More</button>
  </div>

</div><!-- /.container -->

<script>
function removeRow(btn){
  if (btn && btn.parentElement) {
    btn.parentElement.remove();
  }
}

function addImportedBarRow(){
  var container = document.getElementById('importedBarsContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row imported-bar-row align-center';
  row.style.cssText = 'gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<select class="cbase-select w-160">'
    + '  <option value="">Select Steel Size</option>'
    + '  <option>8mm</option>'
    + '  <option>12mm</option>'
    + '  <option>16mm</option>'
    + '  <option>20mm</option>'
    + '  <option>25mm</option>'
    + '</select>'
    + '<input type="text" class="cbase-input w-140" placeholder="Total Length">'
    + '<input type="text" class="cbase-input w-140" placeholder="Bar Quantity">'
    + '<button type="button" onclick="removeRow(this)" class="btn-remove">X</button>';
  container.appendChild(row);
}

function addEquipmentRow(){
  var container = document.getElementById('equipmentContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row equipment-row align-center';
  row.style.cssText = 'gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<select class="cbase-select w-246"><option value="">Select Equipment</option><?php echo $equipmentOptions; ?></select>'
    + '<input type="text" class="cbase-input w-120" placeholder="Quantity">'
    + '<button type="button" onclick="removeRow(this)" class="btn-remove">X</button>';
  container.appendChild(row);
}

function addColumnTypeRow(){
  var container = document.getElementById('columnTypeContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row column-type-row';
  row.style.cssText = 'gap:6px;margin-bottom:6px;align-items:flex-start;';
  row.innerHTML = ''
    + '<div class="flex-column"><label class="label-strong">Number</label><input class="starter-input w-65" placeholder="Number"></div>'
    + '<div class="flex-column"><label class="label-strong">Length</label><input class="starter-input w-70" placeholder="Length"></div>'
    + '<div class="flex-column"><label class="label-strong">Width</label><input class="starter-input w-70" placeholder="Width"></div>'
    + '<div class="flex-column"><label class="label-strong">Bar Type</label><select class="starter-select w-100"><?php echo $steelOptions; ?></select></div>'
    + '<div class="flex-column"><label class="label-strong">Bar Num.</label><input class="starter-input w-70" placeholder="Bar Num."></div>'
    + '<div class="flex-column"><label class="label-strong">A Steel to</label><input class="starter-input w-70" placeholder="A Steel to"></div>'
    + '<div class="flex-column"><label class="label-strong">Stirrups</label><input class="starter-input w-70" placeholder="Stirrups"></div>'
    + '<div class="flex-column"><label class="label-strong">Stirrup Type</label><select class="starter-select w-100"><?php echo $steelOptions; ?></select></div>';
  container.appendChild(row);
}

function addColumnBaseRow(){
  var container = document.getElementById('columnBaseContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'column-base-row row align-center';
  row.style.cssText = 'gap:6px;align-items:center;margin-bottom:6px;';
  row.innerHTML = ''
    + '<input class="cbase-input w-70" placeholder="16">'
    + '<input class="cbase-input w-70" placeholder="1">'
    + '<input class="cbase-input w-70" placeholder="0.15">'
    + '<select class="cbase-select w-100"><?php echo $steelOptions; ?></select>'
    + '<input class="cbase-input w-70" placeholder="14">'
    + '<select class="cbase-select w-120"><option>Single Mat</option><option selected>Double Mat</option></select>'
    + '<input class="cbase-input w-70" value="0.1">';
  container.appendChild(row);
}
</script>

</body>
</html>
