<?php
session_start();
include('script/condb.php'); // DB connection

// Optional: capture project_ref if passed
$PID = $_GET['project_ref'] ?? $_POST['pid'] ?? $_SESSION['pid'] ?? '';
if (!empty($PID)) {
    $_SESSION['pid'] = $PID;
}

/* Pre-build options for JS templates (equipment only) */
$equipmentOptions = '';
$prod_eq = "SELECT construction_equipmentName FROM upline_app_construction_equipment";
$que_eq = mysqli_query($con, $prod_eq);
while ($rec_eq = mysqli_fetch_assoc($que_eq)) {
    $name = htmlspecialchars($rec_eq['construction_equipmentName']);
    $equipmentOptions .= '<option value="'.$name.'">'.$name.'</option>';
}

//----------------------block fromDB----------------------------
$blockOptions = "";
$prod = "SELECT Block_name FROM upline_app_blocksettings";
$que2 = mysqli_query($con, $prod);
while($rec2 = mysqli_fetch_array($que2)){
    $blockOptions .= '<option value="'.$rec2['Block_name'].'">'.$rec2['Block_name'].'</option>';
}

//--------------------------Planks from DB----------------------
$plankOptions = "";
$prod_plank = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='plank'";
$que_plank = mysqli_query($con, $prod_plank);
while($rec_plank = mysqli_fetch_array($que_plank)){
    $plankOptions .= '<option value="'.$rec_plank['plankothers_name'].'">'.$rec_plank['plankothers_name'].'</option>';
}

//--------------------------woods from DB----------------------
$woodOptions ="";
$prod_wood = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='wood'";
$que_wood = mysqli_query($con, $prod_wood);
while($rec_wood = mysqli_fetch_array($que_wood)){
   $woodOptions .= '<option value="'.$rec_wood['plankothers_name'].'">'.$rec_wood['plankothers_name'].'</option>';
}

//--------------steel from DB----------------------------
$steelOptions ="";
$prod_steel = "SELECT steels_wire_name FROM upline_app_steels_wire WHERE steels_wire_type='steel'";
$que_steel = mysqli_query($con, $prod_steel);
while($rec_steel = mysqli_fetch_array($que_steel)){
   $steelOptions .= '<option value="'.$rec_steel['steels_wire_name'].'">'.$rec_steel['steels_wire_name'].'</option>';
}

//------------------------------Concete from DB-----
$concreteOptions ="";
$prod_con1 = "SELECT Mixed_Ratio_Name FROM upline_app_concretework";
$que_con1 = mysqli_query($con, $prod_con1);
while($rec_con1 = mysqli_fetch_array($que_con1)){
    $concreteOptions .= '<option value="'.$rec_con1['Mixed_Ratio_Name'].'">'.$rec_con1['Mixed_Ratio_Name'].'</option>';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Foundation Form</title>
<link href="css/foundation.css" rel="stylesheet" type="text/css">
</head>
<body class="foundation-body">
<div class="container">
  <div class="section-top-title">
    <i data-lucide="layers"></i>FOUNDATION
  </div>

  <!-- === 1. Walls === -->
  <div class="section">

    <!-- HEADER -->
    <div class="flex-between mb-4">
        <!-- Checkbox -->
       <label class="check-row">
  <input type="checkbox" />
  <span>Walls</span>
</label>

    </div>

    <!-- TOP LABELS -->
    <div class="header-row">
        <div class="w-190">Wall Name</div>
        <div class="w-190">Wall Size & Type</div>
        <div class="w-80">Length</div>
        <div class="w-80">Course</div>
        <div class="w-80">Height</div>
    </div>

    <!-- Input styles are defined in CSS families -->
    <div class="row">
        <input type="text" placeholder="Exterior Walls" class="wall-input w-190">
        <select class="wall-select w-190"><?php echo $blockOptions; ?></select>
        <input type="text" placeholder="Length" class="wall-input w-80">
        <input type="text" placeholder="Course" class="wall-input w-80">
        <input type="text" placeholder="Height" class="wall-input input-disabled w-80">
    </div>

    <div class="row">
        <input type="text" placeholder="Interior Walls" class="wall-input w-190">
        <select class="wall-select w-190"><?php echo $blockOptions; ?></select>
        <input type="text" placeholder="Length" class="wall-input w-80">
        <input type="text" placeholder="Course" class="wall-input w-80">
        <input type="text" placeholder="Height" class="wall-input input-disabled w-80">
    </div>

    <div class="row">
        <input type="text" placeholder="Other Interior Walls" class="wall-input w-190">
        <select class="wall-select w-190"><?php echo $blockOptions; ?></select>
        <input type="text" placeholder="Length" class="wall-input w-80">
        <input type="text" placeholder="Course" class="wall-input w-80">
        <input type="text" placeholder="Height" class="wall-input input-disabled w-80">
    </div>

  </div>

  <!-- === 2. Starter Columns & Base === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
               <label class="check-row">
  <input type="checkbox" />
  <span>Columns</span>
</label>
    </div>

    <div class="mb-4" style="height:4px;"></div>

    <div class="flex-row align-center gap-4 mb-6">
        <input type="text" placeholder="16" class="input-red w-70">
        <span class="label-strong">Numbers</span>
    </div>

    <div class="flex-row align-center gap-4 mb-6">
        <input type="text" placeholder="1.25" class="input-red w-70">
        <span class="label-strong">Heights</span>
    </div>

    <!-- Embossed Input Style declared in CSS -->
    <div id="columnTypeContainer">

      <div class="row column-type-row" style="align-items:flex-start;">
          <div class="flex-column">
              <label class="label-strong mb-4">Number</label>
              <input type="text" class="starter-input w-65" placeholder="Number">
          </div>

          <div class="flex-column">
              <label class="label-strong mb-4">Length</label>
              <input type="text" class="starter-input w-70" placeholder="Length">
          </div>

          <div class="flex-column">
              <label class="label-strong mb-4">Width</label>
              <input type="text" class="starter-input w-70" placeholder="Width">
          </div>

          <div class="flex-column">
              <label class="label-strong mb-4">Bar Type</label>
              <select class="starter-select w-100"><?php echo $steelOptions; ?></select>
          </div>

          <div class="flex-column">
              <label class="label-strong mb-4">Bar Num.</label>
              <input type="text" class="starter-input w-70" placeholder="Bar Num.">
          </div>

          <div class="flex-column">
              <label class="label-strong mb-4">A Steel to</label>
              <input type="text" class="starter-input w-70" placeholder="A Steel to">
          </div>

          <div class="flex-column">
              <label class="label-strong mb-4">Stirrups</label>
              <input type="text" class="starter-input w-70" placeholder="Stirrups">
          </div>

          <div class="flex-column">
              <label class="label-strong mb-4">Stirrup Type</label>
              <select class="starter-select w-100"><?php echo $steelOptions; ?></select>
          </div>
      </div>

    </div>

    <button type="button" onclick="addColumnTypeRow()" class="btn-add">+ Add More</button>
  </div>

  <!-- === COLUMN BASES === -->
  <div class="section">
    <div class="section-title" style="font-weight:bold;color:#103049;margin-bottom:6px;">
      <div class="flex-row gap-14 mb-6">
               <label class="check-row">
  <input type="checkbox" />
  <span>Columns Base</span>
</label>
               <label class="check-row-small">
  <input type="checkbox" />
  <span>Include Bending</span>
</label>
      </div>
    </div>

    <div class="flex-row align-center gap-4 mb-6">
        <input type="text" placeholder="16" class="input-red w-70">
        <span class="label-strong">Numbers</span>
    </div>

    <div class="header-row">
        <div class="w-70">Numbers</div>
        <div class="w-70">Width</div>
        <div class="w-70">Height</div>
        <div class="w-100">Bar Types</div>
        <div class="w-70">Bar Num</div>
        <div class="w-120">Mat Types</div>
        <div class="w-70">Bending Ht</div>
    </div>

    <div id="columnBaseContainer">
      <div class="column-base-row row align-center">
        <input type="text" class="cbase-input w-70" placeholder="16">
        <input type="text" class="cbase-input w-70" placeholder="1">
        <input type="text" class="cbase-input w-70" placeholder="0.15">
        <select class="cbase-select w-100"><?php echo $steelOptions; ?></select>
        <input type="text" class="cbase-input w-70" placeholder="14">
        <select class="cbase-select w-120">
            <option>Single Mat</option>
            <option selected>Double Mat</option>
        </select>
        <input type="text" class="cbase-input w-70" value="0.1">
      </div>
    </div>

    <button type="button" onclick="addColumnBaseRow()" class="btn-add">+ Add More</button>
  </div>

  <div class="section-top-title" style="margin:10px 0 10px 0;"><i data-lucide="building-2"></i>PROPERTIES</div>

  <!-- === 3. Partition in Trench === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="check-row">
  <input type="checkbox" />
  <span>Partition in Trench</span>
</label>
    </div>

    <div class="row" style="align-items:flex-start; margin-bottom:10px;">
      <div class="flex-column">
        <label class="label-strong mb-2">Length</label>
        <input class="partition-input w-120" type="text" placeholder="Length">
      </div>
      <div class="flex-column">
        <label class="label-strong mb-2">Width</label>
        <input class="partition-input w-120" type="text" placeholder="Width">
      </div>
      <div class="flex-column">
        <label class="label-strong mb-2">Depth</label>
        <input class="partition-input w-120" type="text" placeholder="Depth">
      </div>
    </div>
  </div>

  <!-- === 4. Blocks & Mortar === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
         <label class="check-row">
  <input type="checkbox" />
  <span>Blocks & Mortars</span>
</label>
    </div>

    <div style="font-size:13px;color:white;font-weight:bold;font-style:italic;margin-bottom:6px;user-select:none;">
        Cement Mortar Ratio
    </div>

    <div class="flex-row gap-6 mb-2">
        <div class="flex-column">
            <label class="label-strong mb-2">Cement</label>
            <input type="text" class="cbase-input w-120" placeholder="Cement">
        </div>
        <div class="flex-column">
            <label class="label-strong mb-2">Sand</label>
            <input type="text" class="cbase-input w-120" placeholder="Sand">
        </div>
    </div>
  </div>

  <!-- === 5. Planks === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
         <label class="check-row">
  <input type="checkbox" />
  <span>Planks</span>
</label>
    </div>

    <div class="row" style="align-items:flex-start; gap:12px; margin-bottom:12px;">
      <div class="flex-column">
        <label class="check-row-small">
  <input type="checkbox" />
  <span>Plank for Column Bases</span>
</label>
        <select class="cbase-select w-200" style="height:24px;"><?php echo $plankOptions; ?></select>
      </div>

      <div class="flex-column">
        <label class="check-row-small">
  <input type="checkbox" />
  <span>Plank for Columns</span>
</label>
        <select class="cbase-select w-200" style="height:24px;"><?php echo $plankOptions; ?></select>
      </div>
    </div>
  </div>

  <!-- === 6. Woods === -->
  <div class="section">
    <div class="flex-row align-center gap-25 mb-4">
         <label class="check-row">
  <input type="checkbox" />
  <span>Woods</span>
</label>
    </div>

    <div class="text-italic-white" style="margin-bottom:8px;">Wood for Column Bracing</div>

    <label class="check-row-small">
  <input type="checkbox" />
  <span>Build Along</span>
</label>

    <div class="header-row">
        <div class="w-200">Wood Type</div>
        <div class="w-120">Length</div>
        <div class="w-120">Number</div>
    </div>

    <div class="row mb-14">
        <select class="cbase-select w-200"><?php echo $woodOptions; ?></select>
        <input type="text" class="cbase-input w-120" placeholder="Length">
        <input type="text" class="cbase-input w-120" placeholder="Number">
    </div>

    <label class="check-row-small">
  <input type="checkbox" />
  <span>Frame Structure</span>
</label>

    <div class="header-row">
        <div class="w-200">Wood Type</div>
        <div class="w-120">Spacing</div>
    </div>

    <div class="row">
        <select class="cbase-select w-200"><?php echo $woodOptions; ?></select>
        <input type="text" class="cbase-input w-120" placeholder="Spacing">
    </div>
  </div>

  <!-- === 7. Stirrups === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
       <label class="check-row">
  <input type="checkbox" />
  <span>Stirrups</span>
</label>
    </div>
  </div>

  <!-- === 8. Bars === -->
  <div class="section">
    <div class="pos-relative" style="margin-top:10px;">
        <label class="check-row">
  <input type="checkbox" />
  <span>Bars</span>
</label>
        <label class="check-row-small">
  <input type="checkbox" />
  <span>Bars for Column Bases</span>
</label>
       <label class="check-row-small">
  <input type="checkbox" />
  <span>Bars for Entire Columns</span>
</label>
    </div>
  </div>

  <!-- === 9. Concrete === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="check-row">
  <input type="checkbox" />
  <span>Concretes</span>
</label>
       <label class="check-row-small">
  <input type="checkbox" />
  <span>Concrete for Column Bases</span>
</label>
    </div>

    <label class="check-row-small">
  <input type="checkbox" />
  <span>Concrete for Blinding</span>
</label>

    <div class="header-row">
        <div class="w-120">Thickness</div>
        <div class="w-160">Concrete Grade</div>
        <div class="w-100">Cement</div>
        <div class="w-100">Sand</div>
        <div class="w-100">Gravel</div>
    </div>

    <div class="row mb-12">
        <input type="text" class="cbase-input w-120" placeholder="Thickness">
        <select class="cbase-select w-160"><?php echo $concreteOptions; ?></select>
        <input type="text" class="cbase-input w-100" placeholder="Cement">
        <input type="text" class="cbase-input w-100" placeholder="Sand">
        <input type="text" class="cbase-input w-100" placeholder="Gravel">
    </div>

   <label class="check-row-small">
  <input type="checkbox" />
  <span>Concrete for Columns</span>
</label>

    <div class="header-row" style="padding-left:128px;">
        <div class="w-160">Concrete Grade</div>
        <div class="w-100">Cement</div>
        <div class="w-100">Sand</div>
        <div class="w-100">Gravel</div>
    </div>

    <div class="row mb-12" style="padding-left:128px;">
        <select class="cbase-select w-160"><?php echo $concreteOptions; ?></select>
        <input type="text" class="cbase-input w-100" placeholder="Cement">
        <input type="text" class="cbase-input w-100" placeholder="Sand">
        <input type="text" class="cbase-input w-100" placeholder="Gravel">
    </div>
  </div>

  <!-- === 10. Imported Bars === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
       <label class="check-row">
  <input type="checkbox" />
  <span>Imported Bars</span>
</label>
    </div>

    <div class="header-row">
        <div class="w-120">Bar Type</div>
        <div class="w-120">Total Length</div>
        <div class="w-120">Bar Quantity</div>
    </div>

    <div id="importedBarsContainer">
      <div class="row imported-bar-row align-center mb-10">
          <select class="cbase-select w-120"><?php echo $steelOptions; ?></select>
          <input type="text" class="cbase-input w-120" placeholder="Total Length">
          <input type="text" class="cbase-input w-120" placeholder="Bar Quantity">
      </div>
    </div>

    <button type="button" onclick="addImportedBarRow()" class="btn-add">+ Add More</button>
  </div>

  <!-- === 11. Plumbing === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="check-row">
  <input type="checkbox" />
  <span>Plumbing Piping</span>
</label>
    </div>

    <div class="header-row">
        <div class="w-120">Materials</div>
        <div class="w-120">Labour</div>
    </div>

    <div class="row">
        <input type="text" class="cbase-input w-120" placeholder="Materials">
        <input type="text" class="cbase-input w-120" placeholder="Labour">
    </div>
  </div>

  <!-- === 12. Electrical === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="check-row">
  <input type="checkbox" />
  <span>Electrical Piping</span>
</label>
    </div>

    <div class="header-row">
        <div class="w-120">Materials</div>
        <div class="w-120">Labour</div>
    </div>

    <div class="row">
        <input type="text" class="cbase-input w-120" placeholder="Materials">
        <input type="text" class="cbase-input w-120" placeholder="Labour">
    </div>
  </div>

  <!-- === 13. Equipments === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="check-row">
  <input type="checkbox" />
  <span>Equipments</span>
</label>
    </div>

    <div class="header-row">
        <div class="w-246">Equipment</div>
        <div class="w-120">Quantity</div>
    </div>

    <div id="equipmentContainer">
      <div class="row equipment-row mb-10 align-center">
          <select class="cbase-select w-246"><?php echo $equipmentOptions; ?></select>
          <input type="text" class="cbase-input w-120" placeholder="Quantity">
      </div>
    </div>

    <button type="button" onclick="addEquipmentRow()" class="btn-add">+ Add More</button>
  </div>

</div><!-- /.container -->

<script>
function removeRow(btn){
  if (btn && btn.parentElement) {
    btn.parentElement.remove();
  }
}

function addImportedBarRow(){
  var container = document.getElementById('importedBarsContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row imported-bar-row align-center';
  row.style.cssText = 'gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<select class="cbase-select w-160">'
    + '  <option value="">Select Steel Size</option>'
    + '  <option>8mm</option>'
    + '  <option>12mm</option>'
    + '  <option>16mm</option>'
    + '  <option>20mm</option>'
    + '  <option>25mm</option>'
    + '</select>'
    + '<input type="text" class="cbase-input w-140" placeholder="Total Length">'
    + '<input type="text" class="cbase-input w-140" placeholder="Bar Quantity">'
    + '<button type="button" onclick="removeRow(this)" class="btn-remove">X</button>';
  container.appendChild(row);
}

function addEquipmentRow(){
  var container = document.getElementById('equipmentContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row equipment-row align-center';
  row.style.cssText = 'gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<select class="cbase-select w-246"><option value="">Select Equipment</option><?php echo $equipmentOptions; ?></select>'
    + '<input type="text" class="cbase-input w-120" placeholder="Quantity">'
    + '<button type="button" onclick="removeRow(this)" class="btn-remove">X</button>';
  container.appendChild(row);
}

function addColumnTypeRow(){
  var container = document.getElementById('columnTypeContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row column-type-row';
  row.style.cssText = 'gap:6px;margin-bottom:6px;align-items:flex-start;';
  row.innerHTML = ''
    + '<div class="flex-column"><label class="label-strong">Number</label><input class="starter-input w-65" placeholder="Number"></div>'
    + '<div class="flex-column"><label class="label-strong">Length</label><input class="starter-input w-70" placeholder="Length"></div>'
    + '<div class="flex-column"><label class="label-strong">Width</label><input class="starter-input w-70" placeholder="Width"></div>'
    + '<div class="flex-column"><label class="label-strong">Bar Type</label><select class="starter-select w-100"><?php echo $steelOptions; ?></select></div>'
    + '<div class="flex-column"><label class="label-strong">Bar Num.</label><input class="starter-input w-70" placeholder="Bar Num."></div>'
    + '<div class="flex-column"><label class="label-strong">A Steel to</label><input class="starter-input w-70" placeholder="A Steel to"></div>'
    + '<div class="flex-column"><label class="label-strong">Stirrups</label><input class="starter-input w-70" placeholder="Stirrups"></div>'
    + '<div class="flex-column"><label class="label-strong">Stirrup Type</label><select class="starter-select w-100"><?php echo $steelOptions; ?></select></div>';
  container.appendChild(row);
}

function addColumnBaseRow(){
  var container = document.getElementById('columnBaseContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'column-base-row row align-center';
  row.style.cssText = 'gap:6px;align-items:center;margin-bottom:6px;';
  row.innerHTML = ''
    + '<input class="cbase-input w-70" placeholder="16">'
    + '<input class="cbase-input w-70" placeholder="1">'
    + '<input class="cbase-input w-70" placeholder="0.15">'
    + '<select class="cbase-select w-100"><?php echo $steelOptions; ?></select>'
    + '<input class="cbase-input w-70" placeholder="14">'
    + '<select class="cbase-select w-120"><option>Single Mat</option><option selected>Double Mat</option></select>'
    + '<input class="cbase-input w-70" value="0.1">';
  container.appendChild(row);
}
</script>
<!--JS For Lucide Icons-->
<script src="https://unpkg.com/lucide@latest"></script>
<script>
  lucide.createIcons();
</script>

</body>
</html>
