<?php
session_start();
include('script/condb.php'); // DB connection

// Optional: capture project_ref if passed
$PID = $_GET['project_ref'] ?? $_POST['pid'] ?? $_SESSION['pid'] ?? '';
if (!empty($PID)) {
    $_SESSION['pid'] = $PID;
}

/* Pre-build options for JS templates (equipment only) */
$equipmentOptions = '';
$prod_eq = "SELECT construction_equipmentName FROM upline_app_construction_equipment";
$que_eq = mysqli_query($con, $prod_eq);
while ($rec_eq = mysqli_fetch_assoc($que_eq)) {
    $name = htmlspecialchars($rec_eq['construction_equipmentName']);
    $equipmentOptions .= '<option value="'.$name.'">'.$name.'</option>';
}


?>
<?php
//----------------------block fromDB----------------------------
//--------------------------------------------------------------
$blockOptions = "";
$prod = "SELECT Block_name FROM upline_app_blocksettings";
    $que2 = mysqli_query($con, $prod);
    while($rec2 = mysqli_fetch_array($que2)){
        $blockOptions .= '<option value="'.$rec2['Block_name'].'">'.$rec2['Block_name'].'</option>';
    }

//--------------------------Planks from DB----------------------
//-------------------------------------------------------------
$plankOptions = "";
$prod_plank = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='plank'";
$que_plank = mysqli_query($con, $prod_plank);

while($rec_plank = mysqli_fetch_array($que_plank)){
    $plankOptions .= '<option value="'.$rec_plank['plankothers_name'].'">'.$rec_plank['plankothers_name'].'</option>';
}
//--------------------------woods from DB----------------------
//-------------------------------------------------------------
$woodOptions ="";
$prod_wood = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='wood'";
            $que_wood = mysqli_query($con, $prod_wood);
            while($rec_wood = mysqli_fetch_array($que_wood)){
               $woodOptions .= '<option value="'.$rec_wood['plankothers_name'].'">'.$rec_wood['plankothers_name'].'</option>';
            }
            
    //--------------steel from DB----------------------------
    //-------------------------------------------------------
 $steelOptions ="";
 $prod_steel = "SELECT steels_wire_name FROM upline_app_steels_wire WHERE steels_wire_type='steel'";
            $que_steel = mysqli_query($con, $prod_steel);
            while($rec_steel = mysqli_fetch_array($que_steel)){
               $steelOptions .= '<option value="'.$rec_steel['steels_wire_name'].'">'.$rec_steel['steels_wire_name'].'</option>';
            }
   //------------------------------Concete from DB-----
   //--------------------------------------------------
   
   $concreteOptions ="";
   $prod_con1 = "SELECT Mixed_Ratio_Name FROM upline_app_concretework";
            $que_con1 = mysqli_query($con, $prod_con1);
            while($rec_con1 = mysqli_fetch_array($que_con1)){
                $concreteOptions .= '<option value="'.$rec_con1['Mixed_Ratio_Name'].'">'.$rec_con1['Mixed_Ratio_Name'].'</option>';
            }
            
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Foundation Form</title>
<link rel="stylesheet" href="foundation.css">
</head>
<body class="foundation-body">
<div class="container">
  <div class="section-top-title">
    GROUND BEAM WITH SOME PADS & RAFT WALLS FOUNDATION
  </div>


<!-- === 1. Walls === -->
<div class="section">

    <!-- Section title / checkbox -->
    <label class="checkbox-label mb-4">
        <input type="checkbox">
        <span class="text-red">Floor Slab</span>
    </label>

    <!-- Header row -->
    <div class="header-row">
        <div class="w-190">Floor Type</div>
        <div class="w-80">Length</div>
        <div class="w-80">Height</div>
        <div class="w-80">Area</div>
    </div>

    <!-- Input row -->
    <div class="row mb-4">
        <input type="text" class="wall-input w-190" placeholder="Floor Slab">
        <input type="text" class="wall-input w-80" placeholder="Length">
        <input type="text" class="wall-input w-80" placeholder="Height">
        <input type="text" class="wall-input input-disabled w-80" placeholder="Area">
    </div>

</div>

<!-- === 2. Ground Beam === -->
<div class="section">

    <!-- Title + Checkbox -->
    <label class="checkbox-label mb-4">
        <input type="checkbox">
        <span class="text-red">Ground Beam</span>
    </label>

    <!-- Header Row -->
    <div class="header-row">
        <div class="w-190">Wall Name</div>
        <div class="w-80">Length</div>
        <div class="w-80">Height</div>
        <div class="w-80">Width</div>
    </div>

    <!-- Input Row -->
    <div class="row mb-4">
        <input type="text" class="wall-input w-190" placeholder="All Walls of Ground Beams">
        <input type="text" class="wall-input w-80" placeholder="Length">
        <input type="text" class="wall-input w-80" placeholder="Height">
        <input type="text" class="wall-input input-disabled w-80" placeholder="Width">
    </div>

</div>

<!-- === 3. Concrete Walls === -->
<div class="section">

    <!-- Title + Checkbox + Refresh Button -->
    <div class="flex-between mb-4">

        <!-- Checkbox -->
        <label class="checkbox-label">
            <input type="checkbox">
            <span class="text-red">Concrete Walls</span>
        </label>

        <!-- Refresh Button -->
        <button id="refreshWallSectionBtn" class="btn-refresh">
            Refresh
        </button>

    </div>

    <!-- Header Row -->
    <div class="header-row">
        <div class="w-190">Wall Name</div>
        <div class="w-80">Wall Size</div>
        <div class="w-80">Length</div>
        <div class="w-80">Height</div>
    </div>

    <!-- Rows -->
    <div class="row mb-4">
        <input type="text" class="wall-input w-190" placeholder="Exterior Walls">
        <input type="text" class="wall-input w-80" placeholder="Wall Size">
        <input type="text" class="wall-input w-80" placeholder="Length">
        <input type="text" class="wall-input input-disabled w-80" placeholder="Height">
    </div>

    <div class="row mb-4">
        <input type="text" class="wall-input w-190" placeholder="Interior Walls">
        <input type="text" class="wall-input w-80" placeholder="Wall Size">
        <input type="text" class="wall-input w-80" placeholder="Length">
        <input type="text" class="wall-input input-disabled w-80" placeholder="Height">
    </div>

    <div class="row">
        <input type="text" class="wall-input w-190" placeholder="Other Walls">
        <input type="text" class="wall-input w-80" placeholder="Wall Size">
        <input type="text" class="wall-input w-80" placeholder="Length">
        <input type="text" class="wall-input input-disabled w-80" placeholder="Height">
    </div>

</div>


<!-- === BLOCK WALLS === -->
<div class="section">

    <!-- Title + Checkbox -->
    <div class="flex-row mb-6">
        <label class="checkbox-label">
            <input type="checkbox">
            <span class="text-red">Block Walls</span>
        </label>
    </div>

    <!-- Header Row -->
    <div class="header-row">
        <div class="w-190">Wall Name</div>
        <div class="w-190">Wall Size</div>
        <div class="w-80">Length</div>
        <div class="w-80">Course</div>
        <div class="w-80">Height</div>
    </div>

    <!-- Exterior Row -->
    <div class="row mb-6">
        <input type="text" class="wall-input w-190" placeholder="Exterior Walls">

        <select class="wall-select w-190">
            <option value="">Select Block</option>
            <?php echo $blockOptions; ?>
        </select>

        <input type="text" class="wall-input w-80" placeholder="Length">
        <input type="text" placeholder="Course" class="wall-input w-80">
        <input type="text" class="wall-input input-disabled w-80" placeholder="Height">
    </div>

    <!-- Interior Row -->
    <div class="row mb-6">
        <input type="text" class="wall-input w-190" placeholder="Interior Walls">

        <select class="wall-select w-190">
            <option value="">Select Block</option>
            <?php echo $blockOptions; ?>
        </select>

        <input type="text" class="wall-input w-80" placeholder="Length">
        <input type="text" placeholder="Course" class="wall-input w-80">
        <input type="text" class="wall-input input-disabled w-80" placeholder="Height">
    </div>

    <!-- Other Walls Row -->
    <div class="row mb-6">
        <input type="text" class="wall-input w-190" placeholder="Other Walls">

        <select class="wall-select w-190">
            <option value="">Select Block</option>
            <?php echo $blockOptions; ?>
        </select>

        <input type="text" class="wall-input w-80" placeholder="Length">
        <input type="text" placeholder="Course" class="wall-input w-80">
        <input type="text" class="wall-input input-disabled w-80" placeholder="Height">
    </div>

</div>

<!-- === Starter Columns & Base === -->
<div class="section">

    <!-- Checkbox Title -->
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label">
            <input type="checkbox">
            <span class="text-red">Columns</span>
        </label>
    </div>

    <!-- Numbers -->
    <div class="flex-row align-center gap-4 mb-6">
        <input type="text" class="input-red w-70" placeholder="16">
        <span class="label-strong">Numbers</span>
    </div>

    <!-- Heights -->
    <div class="flex-row align-center gap-4 mb-6">
        <input type="text" class="input-red w-70" placeholder="1.25">
        <span class="label-strong">Heights</span>
    </div>

    <!-- Column Type Container -->
    <div id="columnTypeContainer">

        <!-- FIRST ROW -->
        <div class="row column-type-row align-start mb-6">

            <!-- Number -->
            <div class="flex-column">
                <label class="label-strong mb-2">Number</label>
                <input type="text" class="starter-input w-65" placeholder="Number">
            </div>

            <!-- Length -->
            <div class="flex-column">
                <label class="label-strong mb-2">Length</label>
                <input type="text" class="starter-input w-70" placeholder="Length">
            </div>

            <!-- Width -->
            <div class="flex-column">
                <label class="label-strong mb-2">Width</label>
                <input type="text" class="starter-input w-70" placeholder="Width">
            </div>

            <!-- Bar Type -->
            <div class="flex-column">
                <label class="label-strong mb-2">Bar Type</label>
                <select class="starter-select w-100">
                    <?php echo $steelOptions; ?>
                </select>
            </div>

            <!-- Bar Num -->
            <div class="flex-column">
                <label class="label-strong mb-2">Bar Num.</label>
                <input type="text" class="starter-input w-70" placeholder="Bar Num.">
            </div>

            <!-- Cut Steel Into -->
            <div class="flex-column">
                <label class="label-strong mb-2">A Steel to</label>
                <input type="text" class="starter-input w-70" placeholder="A Steel to">
            </div>

            <!-- Stirrups -->
            <div class="flex-column">
                <label class="label-strong mb-2">Stirrups</label>
                <input type="text" class="starter-input w-70" placeholder="Stirrups">
            </div>

            <!-- Stirrup Type -->
            <div class="flex-column">
                <label class="label-strong mb-2">Stirrup Type</label>
                <select class="starter-select w-100">
                    <?php echo $steelOptions; ?>
                </select>
            </div>

        </div>

    </div>

    <!-- Add More Button -->
    <button type="button" onclick="addColumnTypeRow()" class="btn-add">
        + Add More
    </button>

</div>


<!-- === COLUMN BASES === -->
<div class="section">

    <!-- TOP CHECKBOXES -->
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label">
            <input type="checkbox">
            <span class="text-red">Columns Base</span>
        </label>

        <label class="checkbox-label">
            <input type="checkbox">
            <span class="label-blue">Include Bending</span>
        </label>
    </div>

    <!-- Column Base Count -->
    <div class="flex-row align-center gap-4 mb-4">
        <input type="text" class="input-red w-70" placeholder="16">
        <span class="label-strong">Numbers</span>
    </div>

    <!-- Header Row -->
    <div class="header-row mb-2">
        <div class="w-70">Numbers</div>
        <div class="w-70">Width</div>
        <div class="w-70">Height</div>
        <div class="w-120">Bar Types</div>
        <div class="w-70">Bar Num</div>
        <div class="w-120">Mat Types</div>
        <div class="w-70">Bending Ht</div>
    </div>

    <!-- ROWS CONTAINER -->
    <div id="columnBaseContainer">

        <!-- First Row -->
        <div class="row mb-4">

            <input type="text" class="cbase-input w-70" placeholder="16">

            <input type="text" class="cbase-input w-70" placeholder="1">

            <input type="text" class="cbase-input w-70" placeholder="0.15">

            <select class="cbase-select w-120">
                <?php echo $steelOptions; ?>
            </select>

            <input type="text" class="cbase-input w-70" placeholder="14">

            <select class="cbase-select w-120">
                <option>Single Mat</option>
                <option selected>Double Mat</option>
            </select>

            <!-- Bending Height (Special formatting preserved) -->
            <input type="text"
                   class="cbase-input w-70"
                   value="0.1"
                   style="border:1px solid #7aaaff;background:#e8f1ff;color:#0040a0;font-weight:bold;">
        </div>

    </div>

    <!-- Add More Button -->
    <button type="button" onclick="addColumnBaseRow()" class="btn-add mt-2">
        + Add More
    </button>

</div>
<div style="width:100%;background:#f7c4c4;color:#4a0000;font-weight:bold;text-align:left;padding-left:14px;padding-bottom:6px;padding-top:6px;margin-bottom:10px;border-radius:4px;font-size:16px;">
    PROPERTIES
  </div>
<!-- === Partition in Trench === -->
<div class="section">

    <!-- 1) TRENCH EXCAVATION CHECKBOX -->
    <label class="checkbox-label mb-6">
        <input type="checkbox">
        <span class="text-red">Trench Excavations</span>
    </label>

    <!-- TRENCH LABEL HEADER -->
    <div class="header-row mb-4">
        <div class="w-120">Partition Lengths</div>
        <div class="w-120">Width</div>
        <div class="w-120">Depth</div>
    </div>

    <!-- TRENCH INPUT ROW -->
    <div class="row mb-14">
        <input type="text" class="partition-input w-120" placeholder="3">
        <input type="text" class="partition-input w-120" placeholder="0.6">
        <input type="text" class="partition-input w-120" placeholder="0.75">
    </div>

    <!-- 2) GROUND EXCAVATION CHECKBOX -->
    <label class="checkbox-label mb-6">
        <input type="checkbox">
        <span class="label-blue">Ground Excavation</span>
    </label>

    <!-- GROUND EXCAVATION LABEL HEADER -->
    <div class="header-row mb-4">
        <div class="w-120">Area</div>
        <div class="w-120">Depth</div>
    </div>

    <!-- GROUND EXCAVATION ROW -->
    <div class="row mb-14">
        <input type="text" class="partition-input w-120" placeholder="500">
        <input type="text" class="partition-input w-120" placeholder="1">
    </div>

    <!-- 3) COLUMN BASE EXCAVATION CHECKBOX -->
    <label class="checkbox-label mb-6">
        <input type="checkbox">
        <span class="label-blue">Column Base Excavation</span>
    </label>

</div>
<!-- === 4. Blocks & Mortar === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Blocks & Mortars</span></label>
    </div>

    <div style="font-size:13px;color:white;font-weight:bold;font-style:italic;margin-bottom:6px;user-select:none;">
        Cement Mortar Ratio
    </div>

    <div class="flex-row gap-6 mb-2">
        <div class="flex-column">
            <label class="label-strong mb-2">Cement</label>
            <input type="text" class="cbase-input w-120" placeholder="Cement">
        </div>
        <div class="flex-column">
            <label class="label-strong mb-2">Sand</label>
            <input type="text" class="cbase-input w-120" placeholder="Sand">
        </div>
    </div>
  </div>
  
<!-- === 5. Planks === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- TOP CHECKBOX -->
    <div style="display:flex;gap:20px;margin-bottom:6px;">
        <label style="display:flex;align-items:center;">
            <input type="checkbox">
            <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
                Planks
            </span>
        </label>
    </div>

    <style>
        .plank-row {
            display:flex;
            align-items:center;
            gap:10px;
            margin-bottom:10px;
        }
        .plank-label {
            display:flex;
            align-items:center;
            font-size:12px;
            color:#0047b3;
            font-weight:bold;
            user-select:none;
            width:260px;          /* ðŸ‘ˆ fixed width so all selects line up */
        }
        .plank-label input {
            margin-right:6px;
            transform:scale(0.9);
            font-size:14px;
        }
        .plank-select {
            width:200px;
            height:24px;
            font-size:14px;
            padding:4px 8px;
            border:1px solid #7f9bbd;
            border-radius:4px;
            background:#f7f7f7;
            color:#777;
            box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
        }
    </style>

    <!-- ROW 1 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for Ground Slab Surrounding</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

    <!-- ROW 2 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for column bases</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

    <!-- ROW 3 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for Ground Beams</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

    <!-- ROW 4 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for Concrete Walls</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

    <!-- ROW 5 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for columns</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

</div>


<!-- === 6. Woods === -->
<div class="section"
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- TOP CHECKBOX -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox">
        <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
            Woods
        </span>
    </label>


    <!-- ========================= -->
    <!-- 1) SUPPORT ON GROUND SLAB -->
    <!-- ========================= -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Support on Ground Slab Surroundings
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Exterior Walls</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <!-- FIELDS -->
    <div style="display:flex;gap:6px;margin-bottom:10px;">
        <input type="text" value="0.6" 
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <select style="width:200px;height:24px;padding:4px 6px;
                       color:#777;background:#f7f7f7;font-weight:300;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                       font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>



    <!-- ========================= -->
    <!-- 2) SUPPORT ON GROUND BEAMS -->
    <!-- ========================= -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Support on Ground Beams
        </span>
    </label>

    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Exterior Walls</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <div style="display:flex;gap:6px;margin-bottom:10px;">
        <input type="text" value="0.6" 
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <select style="width:200px;height:24px;padding:4px 6px;
                       color:#777;background:#f7f7f7;font-weight:300;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                       font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>



    <!-- ============================== -->
    <!-- 3) WOOD FOR CONCRETE WALLS -->
    <!-- ============================== -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Concrete Walls Support
        </span>
    </label>

    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Lengths</div>
        <div style="width:90px; user-select:none;">Wood Spacing</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <!-- EXTERIOR -->
    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="1.5"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <input type="text" value="0.6"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <select style="width:200px;height:24px;padding:4px 6px;
                       background:#f7f7f7;color:#777;font-weight:300;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                       font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>

    <!-- INTERIOR -->
    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="1.5"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <input type="text" value="0.6"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <select style="width:200px;height:24px;padding:4px 6px;
                       background:#f7f7f7;color:#777;font-weight:300;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                       font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>

    <!-- OTHER INTERIOR -->
    <div style="display:flex;gap:6px;margin-bottom:10px;">
        <input type="text" value="1.5"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <input type="text" value="0.6"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <select style="width:200px;height:24px;padding:4px 6px;
                       background:#f7f7f7;color:#777;font-weight:300;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                       font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>



    <!-- ============================== -->
    <!-- 4) WOOD FOR FORMING COLUMNS -->
    <!-- ============================== -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Forming Columns
        </span>
    </label>

    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Spacing</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <div style="display:flex;gap:6px;margin-bottom:10px;">
        <input type="text" value="0.6"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <select style="width:200px;height:24px;padding:4px 6px;
                       background:#f7f7f7;color:#777;font-weight:300;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                       font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>


    <!-- ============================== -->
    <!-- 5) WOOD FOR BRACING COLUMNS -->
    <!-- ============================== -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Bracing Columns
        </span>
    </label>

    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Lengths</div>
        <div style="width:100px; user-select:none;">Numbers</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="1"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <input type="text" value="2"
               style="width:100px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">
        <select style="width:200px;height:24px;padding:4px 6px;
                       background:#f7f7f7;color:#777;font-weight:300;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                       font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>

</div>

<!-- === 7. Stirrups === -->
<div class="section"
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- TITLE CHECKBOX -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox">
        <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
            Stirrups
        </span>
    </label>


    <!-- ================================ -->
    <!-- 1) STIRRUP FOR GROUND BEAMS -->
    <!-- ================================ -->
    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Stirrup for Ground Beams
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;font-weight:bold;color:#103049;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Spacing</div>
        <div style="width:150px; user-select:none;">Bar Types</div>
    </div>

    <!-- FIELDS -->
    <div style="display:flex;gap:6px;margin-bottom:12px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;font-weight:300;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>




    <!-- ================================ -->
    <!-- 2) STIRRUP FOR WALLS -->
    <!-- ================================ -->
    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Stirrup for Walls
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;font-weight:bold;color:#103049;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Spacing</div>
        <div style="width:150px; user-select:none;">Bar Types</div>
    </div>


    <!-- EXTERIOR WALLS -->
    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;font-weight:300;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>


    <!-- INTERIOR WALLS -->
    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;font-weight:300;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>


    <!-- OTHER INTERIOR WALLS -->
    <div style="display:flex;gap:6px;margin-bottom:12px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;font-weight:300;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>




    <!-- ================================ -->
    <!-- 3) STIRRUP FOR COLUMNS -->
    <!-- ================================ -->
    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Stirrup for Columns
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;font-weight:bold;color:#103049;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Spacing</div>
        <div style="width:150px; user-select:none;">Bar Types</div>
    </div>

    <!-- FIELDS -->
    <div style="display:flex;gap:6px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;font-weight:300;color:#777;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;font-weight:300;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                      font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>

</div>

<!-- === 8. Bars === -->
<div class="section"
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- MAIN CHECKBOX -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox">
        <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
            Bars
        </span>
    </label>


    <!-- ========================================================== -->
    <!-- 1) BARS FOR FLOOR SLAB -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Bars for Floor Slab</span>
    </label>

    <!-- TOP LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:4px;">
        <div style="width:90px;">Length Spacing</div>
        <div style="width:90px;">Width Spacing</div>
        <div style="width:80px;">Course</div>
        <div style="width:120px;">Bar Types</div>
        <div style="width:90px;">Overlapping L</div>
        <div style="width:90px;">Reversing L</div>
    </div>

    <!-- FIELDS -->
    <div style="display:flex;gap:6px;margin-bottom:16px;">

        <input type="text" value="0.15" 
            style="width:90px;height:24px;padding:4px 6px;
                   border:1px solid #7f9bbd;border-radius:4px;
                   box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                   font-size:14px;font-weight:300;color:#777;">

        <input type="text" value="0.15"
            style="width:90px;height:24px;padding:4px 6px;
                   border:1px solid #7f9bbd;border-radius:4px;
                   box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                   font-size:14px;font-weight:300;color:#777;">

        <input type="text" value="1"
            style="width:80px;height:24px;padding:4px 6px;
                   border:1px solid #7f9bbd;border-radius:4px;
                   box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                   font-size:14px;font-weight:300;color:#777;">

        <select
            style="width:120px;height:24px;padding:4px 6px;
                   background:#f7f7f7;color:#777;font-weight:300;
                   border:1px solid #7f9bbd;border-radius:4px;
                   box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                   font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>

        <input type="text" value="0.9"
            style="width:90px;height:24px;padding:4px 6px;
                   border:1px solid #7f9bbd;border-radius:4px;
                   box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                   font-size:14px;font-weight:300;color:#777;">

        <input type="text" value="1"
            style="width:90px;height:24px;padding:4px 6px;
                   border:1px solid #7f9bbd;border-radius:4px;
                   box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                   font-size:14px;font-weight:300;color:#777;">
    </div>


<!-- ========================================================== -->
<!-- 2) BARS FOR GROUND BEAMS (UNCHANGED) -->
<!-- ========================================================== -->

<label style="display:flex;align-items:center;margin-bottom:4px;">
    <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
    <span style="color:#0047b3;font-weight:bold;font-size:12px;">Bars for Ground Beams</span>
</label>

<!-- LABEL ROW (REFERENCE GRID) -->
<div style="
    display:flex;align-items:center;gap:6px;
    font-size:12px;color:#103049;font-weight:bold;margin-bottom:4px;">
    <div style="width:90px;"></div>
    <div style="width:90px;">Numbers</div>
    <div style="width:120px;">Bar Types</div>
</div>

<!-- TOP BARS -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:6px;">
    <span style="width:90px;font-size:12px;color:#103049;">Top Bars</span>

    <input type="text" value="5"
        style="width:90px;height:24px;padding:4px 6px;
               border:1px solid #7f9bbd;border-radius:4px;
               box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
               font-size:14px;font-weight:300;color:#777;">

    <select
        style="width:120px;height:24px;padding:4px 6px;
               background:#f7f7f7;color:#777;font-weight:300;
               border-radius:4px;border:1px solid #7f9bbd;
               font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>
</div>

<!-- BOTTOM BARS -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:16px;">
    <span style="width:90px;font-size:12px;color:#103049;">Bottom Bars</span>

    <input type="text" value="5"
        style="width:90px;height:24px;padding:4px 6px;
               border:1px solid #7f9bbd;border-radius:4px;
               box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
               font-size:14px;font-weight:300;color:#777;">

    <select
        style="width:120px;height:24px;padding:4px 6px;
               background:#f7f7f7;color:#777;font-weight:300;
               border-radius:4px;border:1px solid #7f9bbd;
               font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>
</div>





<!-- ========================================================== -->
<!-- 4) BARS FOR RAFT WALLS — EXACT ALIGNMENT VERSION -->
<!-- ========================================================== -->

<label style="display:flex;align-items:center;margin-bottom:4px;">
    <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
    <span style="color:#0047b3;font-weight:bold;font-size:12px;">Bars for Raft Walls</span>
</label>

<!-- COLUMN LABELS (moved 2px further right) -->
<div style="
    display:flex;
    align-items:center;
    gap:6px;
    margin-bottom:4px;
    font-size:12px;
    font-weight:bold;
    color:#103049;

    /* Shift labels + fields 2px right */
    margin-left:182px;
">
    <span style="width:90px;">Spacing</span>
    <span style="width:120px;">Bar Type</span>
</div>

<style>
.raft-row { 
    display:flex; 
    align-items:center; 
    gap:6px; 
    margin-bottom:6px; 
}
.raft-label { 
    width:182px;        /* ALSO moved 2px right to match */
    font-size:12px; 
}
.raft-fields { 
    display:flex; 
    gap:6px;
}
.raft-input {
    width:90px;
    height:24px;
    padding:4px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    color:#777;
    font-size:14px;
}
.raft-select {
    width:120px;
    height:24px;
    padding:4px 6px;
    background:#f7f7f7;
    border:1px solid #7f9bbd;
    border-radius:4px;
    color:#777;
    font-size:14px;
}
</style>

<!-- TOP BARS -->
<div class="raft-row">
    <span class="raft-label">Top Bars on All Walls</span>
    <div class="raft-fields">
        <input type="text" value="3" class="raft-input">
        <select class="raft-select"><?php echo $steelOptions; ?></select>
    </div>
</div>

<!-- BOTTOM BARS -->
<div class="raft-row">
    <span class="raft-label">Bottom Bars on All Walls</span>
    <div class="raft-fields">
        <input type="text" value="2" class="raft-input">
        <select class="raft-select"><?php echo $steelOptions; ?></select>
    </div>
</div>

<!-- EXTERIOR WALLS -->
<div class="raft-row">
    <span class="raft-label">Exterior Walls</span>
    <div class="raft-fields">
        <input type="text" value="4" class="raft-input">
        <select class="raft-select"><?php echo $steelOptions; ?></select>
    </div>
</div>

<!-- INTERIOR WALLS -->
<div class="raft-row">
    <span class="raft-label">Interior Walls</span>
    <div class="raft-fields">
        <input type="text" value="4" class="raft-input">
        <select class="raft-select"><?php echo $steelOptions; ?></select>
    </div>
</div>

<!-- OTHER INTERIOR WALLS -->
<div class="raft-row">
    <span class="raft-label">Other Interior Walls</span>
    <div class="raft-fields">
        <input type="text" value="4" class="raft-input">
        <select class="raft-select"><?php echo $steelOptions; ?></select>
    </div>
</div>


</div>


<!-- === 9. Concrete === -->
<div class="section"
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- MAIN CHECKBOX -->
    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox">
        <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
            Concretes
        </span>
    </label>


    <!-- ======================== FLOOR SLAB ======================== -->

    <label style="display:flex;align-items:center;margin-bottom:2px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concrete for Floor Slab</span>
    </label>

    <!-- TOP LABELS -->
    <div style="display:flex;gap:4px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:70px;">Thickness</div>
        <div style="width:130px;">Concrete Grade</div>
        <div style="width:70px;">Cement</div>
        <div style="width:70px;">Sand</div>
        <div style="width:70px;">Gravel</div>
    </div>

    <div style="display:flex;gap:4px;margin-bottom:6px;align-items:center;">

        <input type="text" value="0.1"
            style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                   color:#777;font-weight:300;font-size:12px;">

        <select style="width:130px;height:24px;padding:4px 6px;background:#f7f7f7;color:#777;
                       border:1px solid #7f9bbd;border-radius:4px;font-size:12px;">
            <?php echo $concreteOptions; ?>
        </select>

        <input type="text" value="1"
               style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      color:#777;font-weight:300;font-size:12px;">

        <input type="text" value="3"
               style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      color:#777;font-weight:300;font-size:12px;">

        <input type="text" value="6"
               style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      color:#777;font-weight:300;font-size:12px;">
    </div>



    <!-- ==================== WALL BLINDING ===================== -->

    <label style="display:flex;align-items:center;margin-bottom:2px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concrete for Wall Blinding</span>
    </label>

    <div style="display:flex;gap:4px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:70px;">Thickness</div>
        <div style="width:130px;">Concrete Grade</div>
        <div style="width:70px;">Cement</div>
        <div style="width:70px;">Sand</div>
        <div style="width:70px;">Gravel</div>
    </div>

    <div style="display:flex;gap:4px;margin-bottom:6px;">

        <input type="text" value="0.1"
               style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      color:#777;font-weight:300;font-size:12px;">

        <select style="width:130px;height:24px;padding:4px 6px;background:#f7f7f7;color:#777;
                       border:1px solid #7f9bbd;border-radius:4px;font-size:12px;">
            <?php echo $concreteOptions; ?>
        </select>

        <input type="text" value="1"
               style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      color:#777;font-weight:300;font-size:12px;">

        <input type="text" value="3.5"
               style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      color:#777;font-weight:300;font-size:12px;">

        <input type="text" value="4.5"
               style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      color:#777;font-weight:300;font-size:12px;">
    </div>




    <!-- ==================== GROUND BEAMS ===================== -->

    <label style="display:flex;align-items:center;margin-bottom:2px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concrete for Ground Beams</span>
    </label>

    <div style="display:flex;gap:4px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:130px;">Concrete Grade</div>
        <div style="width:70px;">Cement</div>
        <div style="width:70px;">Sand</div>
        <div style="width:70px;">Gravel</div>
    </div>

    <div style="display:flex;gap:4px;margin-bottom:6px;">

        <select style="width:130px;height:24px;padding:4px 6px;background:#f7f7f7;color:#777;
                       border-radius:4px;border:1px solid #7f9bbd;font-size:12px;">
            <?php echo $concreteOptions; ?>
        </select>

        <input type="text" value="1"
               style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;
                      color:#777;font-weight:300;font-size:12px;">

        <input type="text" value="3.5"
               style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;
                      color:#777;font-weight:300;font-size:12px;">

        <input type="text" value="4.5"
               style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;
                      color:#777;font-weight:300;font-size:12px;">
    </div>




    <!-- ==================== COLUMNS ===================== -->

    <label style="display:flex;align-items:center;margin-bottom:2px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concretes for Columns</span>
    </label>

    <div style="display:flex;gap:4px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:130px;">Concrete Grade</div>
        <div style="width:70px;">Cement</div>
        <div style="width:70px;">Sand</div>
        <div style="width:70px;">Gravel</div>
    </div>

    <div style="display:flex;gap:4px;margin-bottom:6px;">

        <select style="width:130px;height:24px;padding:4px 6px;background:#f7f7f7;color:#777;
                       border-radius:4px;border:1px solid #7f9bbd;font-size:12px;">
            <?php echo $concreteOptions; ?>
        </select>

        <input type="text" value="1"
               style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;
                      color:#777;font-weight:300;font-size:12px;">

        <input type="text" value="3.5"
               style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;
                      color:#777;font-weight:300;font-size:12px;">

        <input type="text" value="4.5"
               style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;
                      color:#777;font-weight:300;font-size:12px;">
    </div>

</div>


<!-- === 10. Imported Bars === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


  <!-- TITLE ROW -->
  <div style="display:flex;gap:20px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Imported Bars</span>
        </label>

  </div>

  <!-- TOP LABELS -->
  <div style="display:flex;gap:6px;margin-bottom:4px;
              font-size:13px;font-weight:bold;color:#103049;">

      <div style="width:120px;user-select:none;">Bar Type</div>
      <div style="width:120px;user-select:none;">Total Length</div>
      <div style="width:120px;user-select:none;">Bar Quantity</div>

  </div>

  <!-- IMPORTED BARS CONTAINER -->
  <div id="importedBarsContainer">

      <!-- FIRST ROW -->
      <div class="row imported-bar-row" 
           style="display:flex;gap:6px;margin-bottom:10px;align-items:center;">

          <!-- BAR TYPE -->
          <select class="cbase-select" style="width:120px;height:24px;padding:4px 6px;
                         color:#777;background:#f7f7f7;">
               <?php echo $steelOptions; ?>
          </select>

          <!-- TOTAL LENGTH -->
          <input type="text" class="cbase-input" placeholder="Total Length"
                 style="width:120px;height:24px;padding:4px 6px;">

          <!-- BAR QUANTITY -->
          <input type="text" class="cbase-input" placeholder="Bar Quantity"
                 style="width:120px;height:24px;padding:4px 6px;">

      </div>

  </div>

  <!-- ADD BUTTON -->
  <button type="button" onclick="addImportedBarRow()"
          style="margin-top:8px;padding:6px 12px;background:#103049;color:white;
                 border:none;border-radius:4px;cursor:pointer;font-size:14px;">
      + Add More
  </button>

</div>



<!-- === 11. Plumbing === -->
<div class="section">

    <!-- SECTION TITLE -->
    <div class="flex-row gap-20 mb-6">
        <label class="checkbox-label">
            <input type="checkbox">
            <span class="text-red">Plumbing Piping</span>
        </label>
    </div>

    <!-- TOP LABELS -->
    <div class="flex-row gap-6 mb-4 label-strong">
        <div class="w-120">Materials</div>
        <div class="w-120">Labour</div>
    </div>

    <!-- INPUT FIELDS -->
    <div class="flex-row gap-6">
        <input type="text" class="cbase-input w-120" placeholder="Materials">
        <input type="text" class="cbase-input w-120" placeholder="Labour">
    </div>

</div>

<!-- === 12. Electrical === -->
<div class="section">

    <!-- SECTION TITLE -->
    <div class="flex-row gap-20 mb-6">
        <label class="checkbox-label">
            <input type="checkbox">
            <span class="text-red">Electrical Piping</span>
        </label>
    </div>

    <!-- TOP LABELS -->
    <div class="flex-row gap-6 mb-4 label-strong">
        <div class="w-120">Materials</div>
        <div class="w-120">Labour</div>
    </div>

    <!-- INPUT FIELDS -->
    <div class="flex-row gap-6">
        <input type="text" class="cbase-input w-120" placeholder="Materials">
        <input type="text" class="cbase-input w-120" placeholder="Labour">
    </div>

</div>

<!-- === 13. Equipments === -->
  <div class="section">
    <div class="flex-row gap-12 mb-6">
        <label class="checkbox-label"><input type="checkbox"><span class="text-red">Equipments</span></label>
    </div>

    <div class="header-row">
        <div class="w-246">Equipment</div>
        <div class="w-120">Quantity</div>
    </div>

    <div id="equipmentContainer">
      <div class="row equipment-row mb-10 align-center">
          <select class="cbase-select w-246"><?php echo $equipmentOptions; ?></select>
          <input type="text" class="cbase-input w-120" placeholder="Quantity">
      </div>
    </div>

    <button type="button" onclick="addEquipmentRow()" class="btn-add">+ Add More</button>
  </div>

</div><!-- /.container -->

<script>
function removeRow(btn){
  if (btn && btn.parentElement) {
    btn.parentElement.remove();
  }
}

function addImportedBarRow(){
  var container = document.getElementById('importedBarsContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row imported-bar-row align-center';
  row.style.cssText = 'gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<select class="cbase-select w-160">'
    + '  <option value="">Select Steel Size</option>'
    + '  <option>8mm</option>'
    + '  <option>12mm</option>'
    + '  <option>16mm</option>'
    + '  <option>20mm</option>'
    + '  <option>25mm</option>'
    + '</select>'
    + '<input type="text" class="cbase-input w-140" placeholder="Total Length">'
    + '<input type="text" class="cbase-input w-140" placeholder="Bar Quantity">'
    + '<button type="button" onclick="removeRow(this)" class="btn-remove">X</button>';
  container.appendChild(row);
}

function addEquipmentRow(){
  var container = document.getElementById('equipmentContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row equipment-row align-center';
  row.style.cssText = 'gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<select class="cbase-select w-246"><option value="">Select Equipment</option><?php echo $equipmentOptions; ?></select>'
    + '<input type="text" class="cbase-input w-120" placeholder="Quantity">'
    + '<button type="button" onclick="removeRow(this)" class="btn-remove">X</button>';
  container.appendChild(row);
}

function addColumnTypeRow(){
  var container = document.getElementById('columnTypeContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row column-type-row';
  row.style.cssText = 'gap:6px;margin-bottom:6px;align-items:flex-start;';
  row.innerHTML = ''
    + '<div class="flex-column"><label class="label-strong">Number</label><input class="starter-input w-65" placeholder="Number"></div>'
    + '<div class="flex-column"><label class="label-strong">Length</label><input class="starter-input w-70" placeholder="Length"></div>'
    + '<div class="flex-column"><label class="label-strong">Width</label><input class="starter-input w-70" placeholder="Width"></div>'
    + '<div class="flex-column"><label class="label-strong">Bar Type</label><select class="starter-select w-100"><?php echo $steelOptions; ?></select></div>'
    + '<div class="flex-column"><label class="label-strong">Bar Num.</label><input class="starter-input w-70" placeholder="Bar Num."></div>'
    + '<div class="flex-column"><label class="label-strong">A Steel to</label><input class="starter-input w-70" placeholder="A Steel to"></div>'
    + '<div class="flex-column"><label class="label-strong">Stirrups</label><input class="starter-input w-70" placeholder="Stirrups"></div>'
    + '<div class="flex-column"><label class="label-strong">Stirrup Type</label><select class="starter-select w-100"><?php echo $steelOptions; ?></select></div>';
  container.appendChild(row);
}

function addColumnBaseRow(){
  var container = document.getElementById('columnBaseContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'column-base-row row align-center';
  row.style.cssText = 'gap:6px;align-items:center;margin-bottom:6px;';
  row.innerHTML = ''
    + '<input class="cbase-input w-70" placeholder="16">'
    + '<input class="cbase-input w-70" placeholder="1">'
    + '<input class="cbase-input w-70" placeholder="0.15">'
    + '<select class="cbase-select w-100"><?php echo $steelOptions; ?></select>'
    + '<input class="cbase-input w-70" placeholder="14">'
    + '<select class="cbase-select w-120"><option>Single Mat</option><option selected>Double Mat</option></select>'
    + '<input class="cbase-input w-70" value="0.1">';
  container.appendChild(row);
}
</script>



  </body>
  </html>