<?php
session_start();
include('script/condb.php'); // DB connection

// Optional: capture project_ref if passed
$PID = $_GET['project_ref'] ?? $_POST['pid'] ?? $_SESSION['pid'] ?? '';
if (!empty($PID)) {
    $_SESSION['pid'] = $PID;
}

/* Pre-build options for JS templates (equipment only) */
$equipmentOptions = '';
$prod_eq = "SELECT construction_equipmentName FROM upline_app_construction_equipment";
$que_eq = mysqli_query($con, $prod_eq);
while ($rec_eq = mysqli_fetch_assoc($que_eq)) {
    $name = htmlspecialchars($rec_eq['construction_equipmentName']);
    $equipmentOptions .= '<option value="'.$name.'">'.$name.'</option>';
}


?>
<?php
//----------------------block fromDB----------------------------
//--------------------------------------------------------------
$blockOptions = "";
$prod = "SELECT Block_name FROM upline_app_blocksettings";
    $que2 = mysqli_query($con, $prod);
    while($rec2 = mysqli_fetch_array($que2)){
        $blockOptions .= '<option value="'.$rec2['Block_name'].'">'.$rec2['Block_name'].'</option>';
    }

//--------------------------Planks from DB----------------------
//-------------------------------------------------------------
$plankOptions = "";
$prod_plank = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='plank'";
$que_plank = mysqli_query($con, $prod_plank);

while($rec_plank = mysqli_fetch_array($que_plank)){
    $plankOptions .= '<option value="'.$rec_plank['plankothers_name'].'">'.$rec_plank['plankothers_name'].'</option>';
}
//--------------------------woods from DB----------------------
//-------------------------------------------------------------
$woodOptions ="";
$prod_wood = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='wood'";
            $que_wood = mysqli_query($con, $prod_wood);
            while($rec_wood = mysqli_fetch_array($que_wood)){
               $woodOptions .= '<option value="'.$rec_wood['plankothers_name'].'">'.$rec_wood['plankothers_name'].'</option>';
            }
            
    //--------------steel from DB----------------------------
    //-------------------------------------------------------
 $steelOptions ="";
 $prod_steel = "SELECT steels_wire_name FROM upline_app_steels_wire WHERE steels_wire_type='steel'";
            $que_steel = mysqli_query($con, $prod_steel);
            while($rec_steel = mysqli_fetch_array($que_steel)){
               $steelOptions .= '<option value="'.$rec_steel['steels_wire_name'].'">'.$rec_steel['steels_wire_name'].'</option>';
            }
   //------------------------------Concete from DB-----
   //--------------------------------------------------
   
   $concreteOptions ="";
   $prod_con1 = "SELECT Mixed_Ratio_Name FROM upline_app_concretework";
            $que_con1 = mysqli_query($con, $prod_con1);
            while($rec_con1 = mysqli_fetch_array($que_con1)){
                $concreteOptions .= '<option value="'.$rec_con1['Mixed_Ratio_Name'].'">'.$rec_con1['Mixed_Ratio_Name'].'</option>';
            }
            
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Foundation Form</title>
</head>
<body style="font-family:Arial; background:#e5edf7; padding:20px;">

<div class="container">
<div style="width:100%;background:#f7c4c4;color:#4a0000;font-weight:bold;text-align:left;padding-left:14px;padding-bottom:6px;padding-top:6px;margin-bottom:10px;border-radius:4px;font-size:16px;">
    GROUND BEAM WITH SOME PADS & RAFT WALLS FOUNDATION
  </div>


<!-- === 1. Walls === -->
      <!-- Refresh button placed directly above HEIGHT column -->
      <!-- Refresh button correctly aligned above HEIGHT 
<button id="refreshWallSectionBtn"
    style="
        padding:4px 10px;
        background:#103049;
        color:white;
        border:none;
        border-radius:4px;
        cursor:pointer;
        font-size:14px;
        margin-top:15px;
        float:right;

        /* Perfect alignment directly above Height column */
        margin-right:15px;
    ">
    Refresh
</button>-->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

  <!-- TITLE -->
  <div style="margin-bottom:4px;">  <!-- reduced from 8px to 4px -->
      <label style="display:flex;align-items:center;">
          <input type="checkbox">
          <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
              Floor Slab
          </span>
      </label>
  </div>

<!-- FLEX GRID WRAPPER -->
<div style="display:flex;flex-direction:column;gap:4px;"> <!-- reduced gap -->

    <!-- HEADER ROW -->
    <div style="display:flex;gap:6px;font-size:13px;
                font-weight:bold;color:#103049;user-select:none;
                margin-bottom:2px;"> <!-- new smaller margin -->

        <div style="width:190px;">Floor Type</div>
        <div style="width:90px;">Length</div>
        <div style="width:90px;">Height</div>
        <div style="width:90px;">Area</div>

    </div>

    <style>
    .wall-input {
        height:24px;
        font-size:14px;
        padding:3px 6px;
        border:1px solid #7f9bbd;
        border-radius:4px;
        background:#fff;
        box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
    }
    .wall-height {
        background:#f0f0f0;
        color:#666;
    }
    </style>

    <!-- INPUT ROW -->
    <div style="display:flex;gap:6px;margin-bottom:4px;"> <!-- reduced margin -->
        <input type="text" placeholder="Floor Slab" class="wall-input" style="width:190px;">
        <input type="text" placeholder="Length" class="wall-input" style="width:90px;">
        <input type="text" placeholder="Height" class="wall-input" style="width:90px;">
        <input type="text" placeholder="Area" class="wall-input wall-height" style="width:90px;">
    </div>

</div>

</div>

  
<!-- === 2. Grand Beam === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

  <!-- TITLE + CHECKBOX -->
  <div style="display:flex;align-items:center;margin-bottom:4px;"> <!-- reduced from 12px -->
        <label style="display:flex;align-items:center;">
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
                Ground Beam
            </span>
        </label>
  </div>

<!-- WRAPPER FOR FORM -->
<div style="display:flex;flex-direction:column;gap:4px;"> <!-- reduced vertical spacing -->

    <!-- TOP LABELS -->
    <div style="display:flex;gap:6px;
                font-size:13px;font-weight:bold;color:#103049;
                margin-bottom:2px; /* reduced */
                user-select:none;">

        <div style="width:190px;">Wall Name</div>
        <div style="width:90px;">Length</div>
        <div style="width:90px;">Height</div>
        <div style="width:90px;">Width</div>

    </div>

    <!-- Embossed Input Style -->
    <style>
    .wall-input {
        width:100%;
        height:24px;
        padding:3px 6px;
        border:1px solid #7f9bbd;
        border-radius:4px;
        background:#fff;
        box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
        font-size:14px;
    }
    .wall-height {
        background:#f0f0f0;
        color:#666;
    }
    </style>

    <!-- INPUT ROW -->
    <div style="display:flex;gap:6px;margin-bottom:4px;"> <!-- reduced spacing -->
        <input type="text" placeholder="All Walls of Ground Beams" class="wall-input" style="width:190px;">
        <input type="text" placeholder="Length" class="wall-input" style="width:90px;">
        <input type="text" placeholder="Height" class="wall-input" style="width:90px;">
        <input type="text" placeholder="Width" class="wall-input wall-height" style="width:90px;">
    </div>

</div>

</div>


<!-- === COLUMN BASES === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        border-left:4px solid #f4d03f;
        border-radius:6px;

        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

  <!-- TITLE + CHECKBOX + REFRESH BUTTON -->
  <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:4px;">

      <!-- Concrete Walls Checkbox -->
      <div style="display:flex;align-items:center;gap:10px;">
        <label style="display:flex;align-items:center;">
            <input type="checkbox">
            <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
                Concrete Walls
            </span>
        </label>
      </div>

      <!-- Refresh button tightened -->
      <button id="refreshWallSectionBtn"
          style="
              padding:4px 10px;
              background:#103049;
              color:white;
              border:none;
              border-radius:4px;
              cursor:pointer;
              font-size:14px;

              margin-right:20px; /* closer */
          ">
          Refresh
      </button>

  </div>


<!-- TOP LABELS (tightened) -->
<div style="display:flex;gap:6px;
            font-size:13px;font-weight:bold;color:#103049;
            margin-bottom:2px; /* tighter */
            user-select:none;">

    <div style="width:190px;">Wall Name</div>
    <div style="width:90px;">Wall Size</div>
    <div style="width:90px;">Length</div>
    <div style="width:90px;">Height</div>

</div>


<style>
.wall-input {
    width:100%;
    height:24px;
    font-size:14px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#fff;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
.wall-height {
    background:#f0f0f0;
    color:#666;
}
</style>


<!-- ROWS (tight spacing) -->
<div class="row" style="display:flex;gap:6px;margin-bottom:4px;">
  <input type="text" placeholder="Exterior Walls" class="wall-input" style="width:190px;">
  <input type="text" placeholder="Wall Size" class="wall-input" style="width:90px;">
  <input type="text" placeholder="Length" class="wall-input" style="width:90px;">
  <input type="text" placeholder="Height" class="wall-input wall-height" style="width:90px;">
</div>

<div class="row" style="display:flex;gap:6px;margin-bottom:4px;">
  <input type="text" placeholder="Interior Walls" class="wall-input" style="width:190px;">
  <input type="text" placeholder="Wall Size" class="wall-input" style="width:90px;">
  <input type="text" placeholder="Length" class="wall-input" style="width:90px;">
  <input type="text" placeholder="Height" class="wall-input wall-height" style="width:90px;">
</div>

<div class="row" style="display:flex;gap:6px;">
  <input type="text" placeholder="Other Walls" class="wall-input" style="width:190px;">
  <input type="text" placeholder="Wall Size" class="wall-input" style="width:90px;">
  <input type="text" placeholder="Length" class="wall-input" style="width:90px;">
  <input type="text" placeholder="Height" class="wall-input wall-height" style="width:90px;">
</div>

</div>



<!-- === BLOCK WALLS === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">


  <!-- TITLE + CHECKBOX -->
  <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:6px;">
      <div style="display:flex;gap:12px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Block walls</span>
        </label>
      </div>
  </div>


<!-- TOP LABELS -->
<div style="display:flex;gap:8px;
            font-size:13px;font-weight:bold;color:#103049;
            line-height:14px;margin-bottom:4px;">

    <div style="width:190px; user-select:none;">Wall Name</div>
    <div style="width:190px; user-select:none;">Wall Size</div>
    <div style="width:90px;  user-select:none;">Length</div>
    <div style="width:90px;  user-select:none;">Height</div>

</div>


<style>
.wall-input {
    width:100%;
    height:24px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#fff;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
.wall-select {
    width:100%;
    height:24px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#f8f8f8;
    color:#777;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
.wall-height {
    background:#f0f0f0;
    color:#666;
}
</style>


<!-- Exterior -->
<div class="row" style="display:flex;gap:8px;margin-bottom:6px;">
  <input type="text" placeholder="Exterior Walls" class="wall-input" style="width:190px;">

  <select class="wall-select" style="width:190px;">
    <option value="">Select Block</option>
    <?php echo $blockOptions; ?>
  </select>

  <input type="text" placeholder="Length" class="wall-input" style="width:90px;">
  <input type="text" placeholder="Height" class="wall-input wall-height" style="width:90px;">
</div>

<!-- Interior -->
<div class="row" style="display:flex;gap:8px;margin-bottom:6px;">
  <input type="text" placeholder="Interior Walls" class="wall-input" style="width:190px;">

  <select class="wall-select" style="width:190px;">
    <option value="">Select Block</option>
    <?php echo $blockOptions; ?>
  </select>

  <input type="text" placeholder="Length" class="wall-input" style="width:90px;">
  <input type="text" placeholder="Height" class="wall-input wall-height" style="width:90px;">
</div>

<!-- Other Walls -->
<div class="row" style="display:flex;gap:8px;margin-bottom:6px;">
  <input type="text" placeholder="Other Walls" class="wall-input" style="width:190px;">

  <select class="wall-select" style="width:190px;">
    <option value="">Select Block</option>
    <?php echo $blockOptions; ?>
  </select>

  <input type="text" placeholder="Length" class="wall-input" style="width:90px;">
  <input type="text" placeholder="Height" class="wall-input wall-height" style="width:90px;">
</div>

</div>

<!-- === 2. Starter Columns & Base === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

  <!-- TITLE + CHECKBOX (reduced spacing) -->
  <div style="display:flex;gap:12px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Columns</span>
        </label>
  </div>

  <!-- Reduced extra gap -->
  <div style="height:4px;"></div>

  <!-- Numbers -->
  <div style="display:flex;align-items:center;gap:4px;margin-bottom:6px;">
      <input type="text" placeholder="16"
             style="width:70px;height:24px;background:#ffcccc;
                    border:1px solid #b33;padding:2px 6px;font-size:14px;">
      <span style="color:#103049;font-size:12px; user-select:none; font-weight:600;">Numbers</span>
  </div>

  <!-- Heights -->
  <div style="display:flex;align-items:center;gap:4px;margin-bottom:6px;">
      <input type="text" placeholder="1.25"
             style="width:70px;height:24px;background:#ffcccc;
                    border:1px solid #b33;padding:2px 6px;font-size:14px;">
      <span style="color:#103049;font-size:12px;user-select:none;font-weight:600;">Heights</span>
  </div>


<!-- Embossed Input Style -->
<style>
.starter-input {
    width:100%;
    height:24px;
    font-size:14px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#fff;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
.starter-select {
    width:100%;
    height:24px;
    font-size:14px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#f8f8f8;
    color:#777;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
</style>

  <!-- COLUMN TYPE CONTAINER -->
  <div id="columnTypeContainer">

      <!-- FIRST ROW (reduced spacing) -->
      <div class="row column-type-row" 
           style="display:flex;gap:6px;margin-bottom:6px;align-items:flex-start;">

          <!-- Number -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Number</label>
              <input type="text" class="starter-input" placeholder="Number" 
                     style="width:65px;">
          </div>

          <!-- Length -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Length</label>
              <input type="text" class="starter-input" placeholder="Length" 
                     style="width:70px;">
          </div>

          <!-- Width -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Width</label>
              <input type="text" class="starter-input" placeholder="Width" 
                     style="width:70px;">
          </div>

          <!-- Bar Type -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Bar Type</label>
              <select class="starter-select" style="width:100px;">
                  <?php echo $steelOptions; ?>
              </select>
          </div>

          <!-- Bar Numbers -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold;user-select:none;">Bar Num.</label>
              <input type="text"  class="starter-input" placeholder="Bar Num." 
                     style="width:70px;">
          </div>

          <!-- Cut Steel Into -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">A Steel to</label>
              <input type="text" class="starter-input" placeholder="A Steel to" 
                     style="width:70px;">
          </div>

          <!-- Stirrups -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Stirrups</label>
              <input type="text" class="starter-input" placeholder="Stirrups" 
                     style="width:70px;">
          </div>

          <!-- Stirrup Type -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Stirrup Type</label>
              <select class="starter-select" style="width:100px;">
                  <?php echo $steelOptions; ?>
              </select>
          </div>

      </div>

  </div>

<button type="button" onclick="addColumnTypeRow()"
  style="margin-top:6px;padding:6px 12px;background:#103049;color:white;border:none;border-radius:4px;cursor:pointer;font-size:14px;">
  + Add More
</button> 

</div></div>


<!-- === COLUMN BASES === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        border-left:4px solid #f4d03f;
        border-radius:6px;

        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

  <div class="section-title" style="font-weight:bold;color:#103049;margin-bottom:4px;">

    <!-- TOP CHECKBOXES (tightened) -->
    <div style="display:flex;gap:12px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Columns Base</span>
        </label>

        <label>
            <input type="checkbox"> 
            <span style="color:#0047b3;font-weight:bold;font-size:12px;user-select:none;">Include Bending</span>
        </label>
    </div>

    <!-- COLUMN BASE COUNT (tightened) -->
    <div style="display:flex;align-items:center;gap:4px;margin-bottom:4px;">
        <input type="text" placeholder="16"
               style="width:70px;height:24px;background:#ffcccc;
                      border:1px solid #b33;padding:2px 6px;font-size:14px;">
        <span style="color:#103049;font-size:12px; user-select:none;">Numbers</span>
    </div>

    <!-- HEADERS ROW (tight gaps) -->
    <div style="
        display:flex;
        gap:6px;
        margin-bottom:3px;
        font-size:13px;
        font-weight:bold;
        color:#103049;
        user-select:none;
    ">
        <div style="width:70px;">Numbers</div>
        <div style="width:70px;">Width</div>
        <div style="width:70px;">Height</div>
        <div style="width:120px;">Bar Types</div>
        <div style="width:70px;">Bar Num</div>
        <div style="width:120px;">Mat Types</div>
        <div style="width:70px;">Bending Ht</div>
    </div>

<style>
.cbase-input {
    width:100%;
    height:24px;
    font-size:14px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#fff;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}

.cbase-select {
    width:100%;
    height:24px;
    font-size:12px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#f8f8f8;
    color:#777;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
</style>

<!-- BASE ROWS CONTAINER -->
<div id="columnBaseContainer">

    <!-- FIRST ROW (reduced gaps) -->
    <div class="column-base-row"
         style="display:flex;gap:6px;align-items:center;margin-bottom:4px;">

        <input type="text" class="cbase-input" placeholder="16"
               style="width:70px;">

        <input type="text" class="cbase-input" placeholder="1"
               style="width:70px;">

        <input type="text" class="cbase-input" placeholder="0.15"
               style="width:70px;">

        <select class="cbase-select" style="width:120px;">
            <?php echo $steelOptions; ?>
        </select>

        <input type="text" class="cbase-input" placeholder="14"
               style="width:70px;">

        <select class="cbase-select" style="width:120px;">
            <option>Single Mat</option>
            <option selected>Double Mat</option>
        </select>

        <input type="text" class="cbase-input" value="0.1"
               style="
                    width:70px;
                    border:1px solid #7aaaff;
                    background:#e8f1ff;
                    color:#0040a0;
                    font-weight:bold;
               ">
    </div>

</div>

<!-- ADD BUTTON -->
<button type="button" onclick="addColumnBaseRow()"
        style="margin-top:4px;padding:6px 12px;background:#103049;
               color:white;border:none;border-radius:4px;cursor:pointer;font-size:14px;">
    + Add More
</button>

</div></div>



<div style="width:100%;background:#f7c4c4;color:#4a0000;font-weight:bold;text-align:left;padding-left:14px;padding-bottom:6px;padding-top:6px;margin-bottom:10px;border-radius:4px;font-size:16px;">
    PROPERTIES
  </div>
  
  
<!-- === 3. Partition in Trench === -->
<div class="section"  
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">


    <!-- ====================================================== -->
    <!-- 1) TRENCHES EXCAVATIONS (MAIN CHECKBOX)                -->
    <!-- ====================================================== -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox">
        <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
            Trench Excavations
        </span>
    </label>


    <!-- ==== Partition Length / Width / Depth Labels ==== -->
    <div style="display:flex;gap:6px;margin-bottom:4px;
                font-size:12px;color:#103049;font-weight:bold;">
        <div style="width:200px; user-select:none;">Partition Lengths</div>
        <div style="width:120px; user-select:none;">Width</div>
        <div style="width:120px; user-select:none;">Depth</div>
    </div>

    <!-- ==== INPUT ROW ==== -->
    <div style="display:flex;gap:6px;margin-bottom:14px;">
        <input type="text" placeholder="3"
               style="width:200px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <input type="text" placeholder="0.6"
               style="width:120px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <input type="text" placeholder="0.75"
               style="width:120px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
    </div>





    <!-- ====================================================== -->
    <!-- 2) GROUND EXCAVATION                                   -->
    <!-- ====================================================== -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.85);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Ground Excavation
        </span>
    </label>

    <!-- Top Labels -->
    <div style="display:flex;gap:6px;margin-bottom:4px;
                font-size:12px;color:#103049;font-weight:bold;">
        <div style="width:200px; user-select:none;">Area</div>
        <div style="width:120px; user-select:none;">Depth</div>
    </div>

    <!-- INPUT ROW -->
    <div style="display:flex;gap:6px;margin-bottom:14px;">
        <input type="text" placeholder="500"
               style="width:200px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <input type="text" placeholder="1"
               style="width:120px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
    </div>





    <!-- ====================================================== -->
    <!-- 3) COLUMN BASE EXCAVATION                              -->
    <!-- ====================================================== -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.85);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Column Base Excavation
        </span>
    </label>

</div>


<!-- === 4. Blocks & Mortar === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- BLOCKS & MORTAR CHECKBOX -->
    <div style="display:flex;gap:20px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Blocks & Mortars</span>
        </label>
    </div>


    <!-- CEMENT MORTAR RATIO (NOW IMMEDIATELY UNDER CHECKBOX) -->
    <div style="
        font-size:13px;
        color:white;
        font-weight:bold;
        margin-bottom:6px;
        user-select:none;
    ">
        Cement Mortar Ratio
    </div>


    <!-- CEMENT + SAND FIELDS DIRECTLY UNDER RATIO LABEL -->
    <div style="display:flex;gap:6px;margin-bottom:10px;">

        <!-- CEMENT -->
        <div style="display:flex;flex-direction:column;">
            <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Cement</label>
            <input type="text" class="cbase-input" placeholder="Cement"
                   style="width:120px;height:24px;padding:3px 6px;">
        </div>

        <!-- SAND -->
        <div style="display:flex;flex-direction:column;">
            <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Sand</label>
            <input type="text" class="cbase-input" placeholder="Sand"
                   style="width:120px;height:24px;padding:3px 6px;">
        </div>

    </div>

</div>

<!-- === 5. Planks === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- TOP CHECKBOX -->
    <div style="display:flex;gap:20px;margin-bottom:6px;">
        <label style="display:flex;align-items:center;">
            <input type="checkbox">
            <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
                Planks
            </span>
        </label>
    </div>

    <style>
        .plank-row {
            display:flex;
            align-items:center;
            gap:10px;
            margin-bottom:10px;
        }
        .plank-label {
            display:flex;
            align-items:center;
            font-size:12px;
            color:#0047b3;
            font-weight:bold;
            user-select:none;
            width:260px;          /* 👈 fixed width so all selects line up */
        }
        .plank-label input {
            margin-right:6px;
            transform:scale(0.9);
            font-size:14px;
        }
        .plank-select {
            width:200px;
            height:24px;
            font-size:14px;
            padding:4px 8px;
            border:1px solid #7f9bbd;
            border-radius:4px;
            background:#f7f7f7;
            color:#777;
            box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
        }
    </style>

    <!-- ROW 1 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for Ground Slab Surrounding</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

    <!-- ROW 2 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for column bases</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

    <!-- ROW 3 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for Ground Beams</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

    <!-- ROW 4 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for Concrete Walls</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

    <!-- ROW 5 -->
    <div class="plank-row">
        <label class="plank-label">
            <input type="checkbox">
            <span>Plank for columns</span>
        </label>

        <select class="plank-select">
            <option value="">Select Plank</option>
            <?php echo $plankOptions; ?>
        </select>
    </div>

</div>


<!-- === 6. Woods === -->
<div class="section"
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        border-left:4px solid #f4d03f;
        border-radius:6px;

        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- TOP CHECKBOX -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox">
        <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
            Woods
        </span>
    </label>


    <!-- ========================= -->
    <!-- 1) SUPPORT ON GROUND SLAB -->
    <!-- ========================= -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Support on Ground Slab Surroundings
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Exterior Walls</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <!-- FIELDS -->
    <div style="display:flex;gap:6px;margin-bottom:10px;">
        <input type="text" value="0.6" 
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <select style="width:200px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>




    <!-- ========================= -->
    <!-- 2) SUPPORT ON GROUND BEAMS -->
    <!-- ========================= -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Support on Ground Beams
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Exterior Walls</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <div style="display:flex;gap:6px;margin-bottom:10px;">
        <input type="text" value="0.6" 
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <select style="width:200px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>




    <!-- ============================== -->
    <!-- 3) WOOD FOR CONCRETE WALLS -->
    <!-- ============================== -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Concrete Walls Support
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Lengths</div>
        <div style="width:90px; user-select:none;">Wood Spacing</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <!-- EXTERIOR -->
    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="1.5"
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <input type="text" value="0.6"
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <select style="width:200px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>

    <!-- INTERIOR -->
    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="1.5"
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <input type="text" value="0.6"
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <select style="width:200px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>

    <!-- OTHER INTERIOR -->
    <div style="display:flex;gap:6px;margin-bottom:10px;">
        <input type="text" value="1.5"
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <input type="text" value="0.6"
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <select style="width:200px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>




    <!-- ============================== -->
    <!-- 4) WOOD FOR FORMING COLUMNS -->
    <!-- ============================== -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Forming Columns
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Spacing</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <div style="display:flex;gap:6px;margin-bottom:10px;">
        <input type="text" value="0.6"
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <select style="width:200px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>




    <!-- ============================== -->
    <!-- 5) WOOD FOR BRACING COLUMNS -->
    <!-- ============================== -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="transform:scale(0.9);margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Wood for Bracing Columns
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Lengths</div>
        <div style="width:100px; user-select:none;">Numbers</div>
        <div style="width:200px; user-select:none;">Wood Types</div>
    </div>

    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="1"
               style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <input type="text" value="2"
               style="width:100px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <select style="width:200px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;
                       box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $woodOptions; ?>
        </select>
    </div>

</div>


<!-- === 7. Stirrups === -->
<div class="section"
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        border-left:4px solid #f4d03f;
        border-radius:6px;

        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- TITLE CHECKBOX -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox">
        <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
            Stirrups
        </span>
    </label>


    <!-- ================================ -->
    <!-- 1) STIRRUP FOR GROUND BEAMS -->
    <!-- ================================ -->
    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Stirrup for Ground Beams
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;font-weight:bold;color:#103049;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Spacing</div>
        <div style="width:150px; user-select:none;">Bar Types</div>
    </div>

    <!-- FIELDS -->
    <div style="display:flex;gap:6px;margin-bottom:12px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>




    <!-- ================================ -->
    <!-- 2) STIRRUP FOR WALLS -->
    <!-- ================================ -->
    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Stirrup for Walls
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;font-weight:bold;color:#103049;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Spacing</div>
        <div style="width:150px; user-select:none;">Bar Types</div>
    </div>


    <!-- EXTERIOR WALLS -->
    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>


    <!-- INTERIOR WALLS -->
    <div style="display:flex;gap:6px;margin-bottom:6px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>


    <!-- OTHER INTERIOR WALLS -->
    <div style="display:flex;gap:6px;margin-bottom:12px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>




    <!-- ================================ -->
    <!-- 3) STIRRUP FOR COLUMNS -->
    <!-- ================================ -->
    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Stirrup for Columns
        </span>
    </label>

    <!-- LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;font-weight:bold;color:#103049;margin-bottom:2px;">
        <div style="width:90px; user-select:none;">Spacing</div>
        <div style="width:150px; user-select:none;">Bar Types</div>
    </div>

    <!-- FIELDS -->
    <div style="display:flex;gap:6px;">
        <input type="text" value="0.25"
               style="width:90px;height:24px;padding:4px 6px;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select
               style="width:150px;height:24px;padding:4px 6px;
                      color:#777;background:#f7f7f7;
                      border:1px solid #7f9bbd;border-radius:4px;
                      box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>

</div>

<!-- === 8. Bars === -->
<div class="section"
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        border-left:4px solid #f4d03f;
        border-radius:6px;

        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- MAIN CHECKBOX -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox">
        <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
            Bars
        </span>
    </label>



    <!-- ========================================================== -->
    <!-- 1) BARS FOR FLOOR SLAB -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Bars for Floor Slab</span>
    </label>

    <!-- TOP LABELS -->
    <div style="display:flex;gap:6px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:4px;">
        <div style="width:90px;">Length Spacing</div>
        <div style="width:90px;">Width Spacing</div>
        <div style="width:80px;">Course</div>
        <div style="width:120px;">Bar Types</div>
        <div style="width:90px;">Overlapping L</div>
        <div style="width:90px;">Reversing L</div>
    </div>

    <!-- FIELDS -->
    <div style="display:flex;gap:6px;margin-bottom:16px;">
        <input type="text" value="0.15" style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <input type="text" value="0.15" style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <input type="text" value="1" style="width:80px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select style="width:120px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>

        <input type="text" value="0.9" style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <input type="text" value="1" style="width:90px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
    </div>





    <!-- ========================================================== -->
    <!-- 2) BARS FOR GROUND BEAMS -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Bars for Ground Beams</span>
    </label>

    <!-- LABELS -->
    <!-- LABELS ROW (Perfectly aligned above input fields) -->
<div style="
    display:flex;
    align-items:center;
    gap:6px;
    font-size:12px;
    color:#103049;
    font-weight:bold;
    margin-bottom:4px;
">

    <!-- Spacer to align over "Top Bars" label -->
    <div style="width:80px;"></div>

    <!-- Numbers -->
    <div style="width:70px; text-align:left;">Numbers</div>

    <!-- Bar Types -->
    <div style="width:150px; text-align:left;">Bar Types</div>
</div>


<!-- TOP BARS ROW -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:6px;">

    <!-- Row Label -->
    <span style="width:80px;font-size:12px;color:#103049;">Top Bars</span>

    <!-- Numbers Input -->
    <input type="text" value="5"
           style="width:70px;height:24px;padding:4px 6px;
                  border:1px solid #7f9bbd;border-radius:4px;
                  box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
                  font-size:14px;">

    <!-- Bar Types Dropdown -->
    <select style="width:150px;height:24px;padding:4px 6px;
                   color:#777;background:#f7f7f7;
                   border:1px solid #7f9bbd;border-radius:4px;
                   font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>

</div>


    <!-- BOTTOM BARS -->
    <div style="display:flex;align-items:center;gap:6px;margin-bottom:16px;">
        <span style="width:80px;font-size:12px;color:#103049;">Bottom Bars</span>
        <input type="text" value="5" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select style="width:150px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>



    <!-- ========================================================== -->
    <!-- 3) STANDING BARS FOR EXTERIOR WALLS -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Standing Bars for Exterior Walls</span>
    </label>

    <div style="display:flex;gap:6px;font-size:12px;font-weight:bold;color:#103049;margin-bottom:4px;">
        <div style="width:120px;">Length of Each Bars</div>
        <div style="width:120px;">Spacing</div>
        <div style="width:150px;">Bar Types</div>
    </div>

    <div style="display:flex;gap:6px;margin-bottom:16px;">
        <input type="text" value="2" style="width:120px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">
        <input type="text" value="0.15" style="width:120px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);font-size:14px;">

        <select style="width:150px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;
                       border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
            <?php echo $steelOptions; ?>
        </select>
    </div>



    <!-- ========================================================== -->
    <!-- 4) BARS FOR RAFT WALLS -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Bars for Raft Walls</span>
    </label>

    

   <!-- TOP LABELS (NEWLY ADDED) -->
<div style="
    display:flex;
    align-items:center;
    gap:6px;
    margin-bottom:4px;
    font-size:12px;
    font-weight:bold;
    color:#103049;
    user-select:none;
">
    <span style="width:130px;"></span> <!-- empty placeholder to align labels -->
    <span style="width:70px;">Spacing</span>
    <span style="width:150px;">Bar Type</span>
</div>


<!-- TOP BARS -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:6px;">
    <span style="width:130px;font-size:12px;">Top Bars on All Walls</span>
    <input type="text" value="3" 
        style="width:70px;height:24px;padding:4px 6px;
               border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
    <select style="width:150px;height:24px;padding:4px 6px;
                   background:#f7f7f7;color:#777;
                   border-radius:4px;border:1px solid #7f9bbd;font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>
</div>

<!-- BOTTOM BARS -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:6px;">
    <span style="width:130px;font-size:12px;">Bottom Bars on All Walls</span>
    <input type="text" value="2" 
        style="width:70px;height:24px;padding:4px 6px;
               border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
    <select style="width:150px;height:24px;padding:4px 6px;
                   background:#f7f7f7;color:#777;
                   border-radius:4px;border:1px solid #7f9bbd;font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>
</div>

<!-- EXTERIOR WALLS -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:6px;">
    <span style="width:130px;font-size:12px;">Exterior Walls</span>
    <input type="text" value="4" 
        style="width:70px;height:24px;padding:4px 6px;
               border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
    <select style="width:150px;height:24px;padding:4px 6px;
                   background:#f7f7f7;color:#777;
                   border-radius:4px;border:1px solid #7f9bbd;font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>
</div>

<!-- INTERIOR WALLS -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:6px;">
    <span style="width:130px;font-size:12px;">Interior Walls</span>
    <input type="text" value="4" 
        style="width:70px;height:24px;padding:4px 6px;
               border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
    <select style="width:150px;height:24px;padding:4px 6px;
                   background:#f7f7f7;color:#777;
                   border-radius:4px;border:1px solid #7f9bbd;font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>
</div>

<!-- OTHER INTERIOR WALLS -->
<div style="display:flex;align-items:center;gap:6px;margin-bottom:12px;">
    <span style="width:130px;font-size:12px;">Other Interior Walls</span>
    <input type="text" value="4" 
        style="width:70px;height:24px;padding:4px 6px;
               border:1px solid #7f9bbd;border-radius:4px;font-size:14px;">
    <select style="width:150px;height:24px;padding:4px 6px;
                   background:#f7f7f7;color:#777;
                   border-radius:4px;border:1px solid #7f9bbd;font-size:14px;">
        <?php echo $steelOptions; ?>
    </select>
</div>


    <!-- Placeholder for the last checkbox -->
    <label style="display:flex;align-items:center;margin-top:6px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Bars for Columns</span>
    </label>

</div>

<!-- === 9. Concrete === -->
<div class="section"
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- MAIN CHECKBOX -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox">
        <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
           Concretes
        </span>
    </label>


    <!-- ========================================================== -->
    <!-- 1) CONCRETE FOR FLOOR SLAB -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:3px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concrete for Floor Slab</span>
    </label>

    <!-- TOP LABELS -->
    <div style="display:flex;gap:8px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:3px;">
       
        <div style="width:70px;">Thickness</div>
        <div style="width:130px;">Concrete Grade</div>
        <div style="width:70px;">Cement</div>
        <div style="width:70px;">Sand</div>
        <div style="width:70px;">Gravel</div>
    </div>

    <div style="display:flex;gap:8px;margin-bottom:10px;align-items:center;">
               <input type="text" value="0.1"
            style="width:70px;height:24px;padding:4px 6px;
                   border:1px solid #7f9bbd;border-radius:4px;
                   box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);">

        <select style="width:130px;height:24px;padding:4px 6px;background:#f7f7f7;color:#777;
                       border:1px solid #7f9bbd;border-radius:4px;">
            <?php echo $concreteOptions; ?>
        </select>

        <input type="text" value="1" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;">
        <input type="text" value="3" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;">
        <input type="text" value="6" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;">
    </div>


    <!-- ========================================================== -->
    <!-- 2) CONCRETE FOR COLUMN BASE -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:3px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concrete for Column Base</span>
    </label>


    <!-- ========================================================== -->
    <!-- 3) CONCRETE FOR WALL BLINDING -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:3px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concrete for Wall Blinding</span>
    </label>

    <div style="display:flex;gap:8px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:3px;">
        <div style="width:70px;">Thickness</div>
        <div style="width:130px;">Concrete Grade</div>
        <div style="width:70px;">Cement</div>
        <div style="width:70px;">Sand</div>
        <div style="width:70px;">Gravel</div>
    </div>

    <div style="display:flex;gap:8px;margin-bottom:10px;">
        <input type="text" value="0.1"
               style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;">

        <select style="width:130px;height:24px;padding:4px 6px;background:#f7f7f7;color:#777;border:1px solid #7f9bbd;border-radius:4px;">
            <?php echo $concreteOptions; ?>
        </select>

        <input type="text" value="1" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;">
        <input type="text" value="3.5" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;">
        <input type="text" value="4.5" style="width:70px;height:24px;padding:4px 6px;border:1px solid #7f9bbd;border-radius:4px;">
    </div>


    <!-- ========================================================== -->
    <!-- 4) CONCRETE FOR GROUND BEAMS -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:3px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concrete for Ground Beams</span>
    </label>

    <div style="display:flex;gap:8px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:3px;">
        <div style="width:130px;">Concrete Grade</div>
        <div style="width:70px;">Cement</div>
        <div style="width:70px;">Sand</div>
        <div style="width:70px;">Gravel</div>
    </div>

    <div style="display:flex;gap:8px;margin-bottom:10px;">
        <select style="width:130px;height:24px;padding:4px 6px;background:#f7f7f7;color:#777;border:1px solid #7f9bbd;border-radius:4px;">
            <?php echo $concreteOptions; ?>
        </select>

        <input type="text" value="1" style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;">
        <input type="text" value="3.5" style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;">
        <input type="text" value="4.5" style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;">
    </div>


    <!-- ========================================================== -->
    <!-- 5) CONCRETE FOR WALLS -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:3px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concrete for Walls</span>
    </label>

    


    <!-- ========================================================== -->
    <!-- 6) CONCRETE FOR COLUMNS -->
    <!-- ========================================================== -->

    <label style="display:flex;align-items:center;margin-bottom:3px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;">Concretes for Columns</span>
    </label>
    <div style="display:flex;gap:8px;font-size:12px;color:#103049;font-weight:bold;margin-bottom:3px;">
        <div style="width:130px;">Concrete Grade</div>
        <div style="width:70px;">Cement</div>
        <div style="width:70px;">Sand</div>
        <div style="width:70px;">Gravel</div>
    </div>

    <div style="display:flex;gap:8px;margin-bottom:10px;">
        <select style="width:130px;height:24px;padding:4px 6px;background:#f7f7f7;color:#777;border-radius:4px;border:1px solid #7f9bbd;">
            <?php echo $concreteOptions; ?>
        </select>

        <input type="text" value="1" style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;">
        <input type="text" value="3.5" style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;">
        <input type="text" value="4.5" style="width:70px;height:24px;padding:4px 6px;border-radius:4px;border:1px solid #7f9bbd;">
    </div>

</div>

<!-- === 10. Imported Bars === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


  <!-- TITLE ROW -->
  <div style="display:flex;gap:20px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Imported Bars</span>
        </label>

  </div>

  <!-- TOP LABELS -->
  <div style="display:flex;gap:6px;margin-bottom:4px;
              font-size:13px;font-weight:bold;color:#103049;">

      <div style="width:130px;user-select:none;">Bar Type</div>
      <div style="width:120px;user-select:none;">Total Length</div>
      <div style="width:120px;user-select:none;">Bar Quantity</div>

  </div>

  <!-- IMPORTED BARS CONTAINER -->
  <div id="importedBarsContainer">

      <!-- FIRST ROW -->
      <div class="row imported-bar-row" 
           style="display:flex;gap:6px;margin-bottom:10px;align-items:center;">

          <!-- BAR TYPE -->
          <select class="cbase-select" style="width:130px;height:24px;padding:4px 6px;
                         color:#777;background:#f7f7f7;">
               <?php echo $steelOptions; ?>
          </select>

          <!-- TOTAL LENGTH -->
          <input type="text" class="cbase-input" placeholder="Total Length"
                 style="width:120px;height:24px;padding:4px 6px;">

          <!-- BAR QUANTITY -->
          <input type="text" class="cbase-input" placeholder="Bar Quantity"
                 style="width:120px;height:24px;padding:4px 6px;">

      </div>

  </div>

  <!-- ADD BUTTON -->
  <button type="button" onclick="addImportedBarRow()"
          style="margin-top:8px;padding:6px 12px;background:#103049;color:white;
                 border:none;border-radius:4px;cursor:pointer;font-size:14px;">
      + Add More
  </button>

</div>


<!-- === 11. Plumbing === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


  <!-- SECTION TITLE -->
  <div style="display:flex;gap:20px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Plumbing Piping</span>
        </label>

  </div>

  <!-- TOP LABELS -->
  <div style="display:flex;gap:6px;margin-bottom:4px;
              font-size:13px;font-weight:bold;color:#103049;">

      <div style="width:120px;user-select:none;font-weight:bold;">Materials</div>
      <div style="width:120px;user-select:none;font-weight:bold;">Labour</div>

  </div>

  <!-- INPUT FIELDS -->
  <div class="row" style="display:flex;gap:6px;">
      <input type="text" class="cbase-input" placeholder="Materials"
             style="width:120px;height:24px;padding:4px 6px;">

      <input type="text" class="cbase-input" placeholder="Labour"
             style="width:120px;height:24px;padding:4px 6px;">
  </div>

</div>


<!-- === 12. Electrical === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


  <!-- SECTION TITLE 
  <div class="section-title" 
       style="font-weight:bold;color:#103049;margin-bottom:12px;">
      <input type="checkbox">
      <span style="color:#900;font-weight:bold;">Electrical Piping</span>-->
      <div style="display:flex;gap:20px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Electrical Piping</span>
        </label>

  </div>

  <!-- TOP LABELS -->
  <div style="display:flex;gap:6px;margin-bottom:4px;
              font-size:13px;font-weight:bold;color:#103049;">

      <div style="width:120px;user-select:none;font-weight:bold;">Materials</div>
      <div style="width:120px;user-select:none;font-weight:bold;">Labour</div>

  </div>

  <!-- INPUT FIELDS -->
  <div class="row" style="display:flex;gap:6px;">
      <input type="text" class="cbase-input" placeholder="Materials"
             style="width:120px;height:24px;padding:4px 6px;">

      <input type="text"class="cbase-input" placeholder="Labour"
             style="width:120px;height:24px;padding:4px 6px;">
  </div>

</div>


<!-- === 13. Equipments === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


  <!-- TITLE 
  <div class="section-title" 
       style="font-weight:bold;color:#103049;margin-bottom:12px;">
      <input type="checkbox"> 
      <span style="color:#900;font-weight:bold;"> Equipments to be Used </span>-->
      <div style="display:flex;gap:20px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; ">Equipments </span>
        </label>

  </div>

  <!-- TOP LABELS -->
  <div style="display:flex;gap:6px;margin-bottom:4px;
              font-size:13px;font-weight:bold;color:#103049;">
      <div style="width:246px;user-select:none;">Equipment</div>
      <div style="width:120px;user-select:none;">Quantity</div>
  </div>

  <!-- FIRST ROW -->
  <div id="equipmentContainer">
      <div class="row equipment-row" 
           style="display:flex;gap:6px;margin-bottom:10px;align-items:center;">

          <select class="cbase-select" style="width:246px;height:24px;padding:4px 6px;
                         color:#777;background:#f8f8f8;">
              <option value="">Select Equipment</option>
              <?php echo $equipmentOptions; ?>
          </select>

          <input type="text" class="cbase-input" placeholder="Quantity"
                 style="width:120px;height:24px;padding:4px 6px;">
      </div>
  </div>

  <!-- ADD BUTTON -->
  <button type="button" onclick="addEquipmentRow()"
          style="margin-top:8px;padding:6px 12px;background:#103049;
                 color:white;border:none;border-radius:4px;cursor:pointer;font-size:14px;">
      + Add More
  </button>

</div>

</div><!-- /.container -->

<script>
function removeRow(btn){
  // remove the row that contains this button
  if (btn && btn.parentElement) {
    btn.parentElement.remove();
  }
}

function addImportedBarRow(){
  var container = document.getElementById('importedBarsContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row imported-bar-row';
  row.style.cssText = 'display:flex;gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<select style="width:160px;">'
    + '  <option value="">Select Steel Size</option>'
    + '  <option>8mm</option>'
    + '  <option>12mm</option>'
    + '  <option>16mm</option>'
    + '  <option>20mm</option>'
    + '  <option>25mm</option>'
    + '</select>'
    + '<input type="text" placeholder="Total Length" style="width:140px;">'
    + '<input type="text" placeholder="Bar Quantity" style="width:140px;">'
    + '<button type="button" onclick="removeRow(this)" '
    + 'style="padding:4px 10px;background:#c0392b;color:white;border:none;border-radius:4px;cursor:pointer;">X</button>';
  container.appendChild(row);
}

function addEquipmentRow(){
  var container = document.getElementById('equipmentContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row equipment-row';
  row.style.cssText = 'display:flex;gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<input type="text" placeholder="Quantity" style="width:120px;">'
    + '<select style="width:240px;">'
    + '  <option value="">Select Equipment</option>'
    + '  <?php echo $equipmentOptions; ?>'
    + '</select>'
    + '<button type="button" onclick="removeRow(this)" '
    + 'style="padding:4px 10px;background:#c0392b;color:white;border:none;border-radius:4px;cursor:pointer;">X</button>';
  container.appendChild(row);
}
</script>

</body>
</html>
