<?php
session_start();
include("script/condb.php");

// Show errors for debugging (disable later)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Validate project_ref
if (!isset($_GET['project_ref'])) {
    die("Error: Project reference not specified.");
}
$project_ref = $_GET['project_ref'];

// Fetch project record
$query = "SELECT * FROM upline_app_project_info WHERE project_ref = ?";
$stmt = $con->prepare($query);
$stmt->bind_param("s", $project_ref);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc() ?? [];

// Handle form submit
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $projecttype = $_POST['projecttype'] ?? '';
    $projectname = $_POST['projectname'] ?? '';
    $projectaddress = $_POST['projectaddress'] ?? '';
    $lga = $_POST['lga'] ?? '';
    $state = $_POST['state'] ?? '';
    $poweredby = $_POST['poweredby'] ?? '';
    $default_uom = $_POST['default_uom'] ?? '';
    $website = $_POST['website'] ?? '';
    $email = $_POST['email'] ?? '';
    $telephone = $_POST['telephone'] ?? '';

    $update = "UPDATE upline_app_project_info SET 
        project_type = ?, 
        project_name = ?, 
        project_address = ?, 
        project_location_lga = ?, 
        project_location_state = ?, 
        project_developer= ?, 
        default_uom = ?, 
        project_developer_website = ?, 
        project_developer_email = ?, 
        project_developer_phone = ?
        WHERE project_ref = ?";

    $stmt2 = $con->prepare($update);
    $stmt2->bind_param(
        "sssssssssss",
        $projecttype,
        $projectname,
        $projectaddress,
        $lga,
        $state,
        $poweredby,
        $default_uom,
        $website,
        $email,
        $telephone,
        $project_ref
    );

    if ($stmt2->execute()) {
        echo "<script>
                alert('Project information updated successfully!');
                window.location.href = 'project_detail.php?project_ref=" . $project_ref . "';
              </script>";
        exit();
    } else {
        echo "Error updating record: " . $stmt2->error;
    }
}
?>
<!doctype html>
<html>
<head>
<meta charset="UTF-8">
<title>TQ Dashboard</title>
<link href="css/styles.css" rel="stylesheet" type="text/css">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>

<body>
<div class="dashboardpagewrap">
<div class="right-frame">
<div class="page-tag">
  <img src="images/settings-ico2.png" width="128" height="128" alt=""/> Project Informations Edit
 </div>

<div class="accordion-wrapper">
    <!-- Back to Dashboard button (top-right corner) -->
  <div class="flex justify-end mb-4">
      <a href="javascript:history.back()" class="bg-blue-600 text-white px-3 py-2 rounded hover:bg-blue-700">
    ← Go Back
</a>
  </div>
<div class="worko-tabs">
<input class="state" type="radio" title="tab-one" name="tabs-state" id="tab-one" checked />

<div class="tabs flex-tabs">
<label for="tab-one" id="tab-one-label" class="tab"></label>

<div id="tab-one-panel" class="panel active">
    <p style="color:white">Your Project Number is <?= htmlspecialchars($row['project_ref'] ?? '') ?></p>
<form class="left-form" action="" method="post" name="pro">
  <div class="form-input-title">Project Type</div>
  <input type="text" class="text-input-box" name="projecttype" value="<?= htmlspecialchars($row['project_type'] ?? '') ?>">

  <div class="form-input-title">Project Name</div>
  <input type="text" class="text-input-box" name="projectname" value="<?= htmlspecialchars($row['project_name'] ?? '') ?>">

  <div class="form-input-title">Project Address</div>
  <input type="text" class="text-input-box" name="projectaddress" value="<?= htmlspecialchars($row['project_address'] ?? '') ?>">

  <div class="form-input-title">Local Government Area</div>
  <input type="text" class="text-input-box" name="lga" value="<?= htmlspecialchars($row['lga'] ?? '') ?>">

  <div class="form-input-title">State</div>
  <input type="text" class="text-input-box" name="state" value="<?= htmlspecialchars($row['state'] ?? '') ?>">

  <div class="form-input-title">Powered By</div>
  <input type="text" class="text-input-box" name="poweredby" value="<?= htmlspecialchars($row['powered_by'] ?? '') ?>">

  <div class="form-input-title">Default Unit of Measurement (UOM)</div>
  <select class="text-input-box" name="default_uom" required>
    <?php
    $uoms = ['inch' => 'Inches (in)', 'cm' => 'Centimeters (cm)', 'm' => 'Meters (m)', 'yd' => 'Yards (yd)', 'px' => 'Pixels (px)'];
    $currentUOM = $row['default_uom'] ?? '';
    foreach ($uoms as $value => $label) {
        $selected = ($currentUOM === $value) ? 'selected' : '';
        echo "<option value='$value' $selected>$label</option>";
    }
    ?>
  </select>

  <input type="submit" name="btnproj" class="sub_btn" value="Save Informations">
  <input type="reset" class="sub_btn" value="Cancel">
</form>

<form class="right-form" action="" method="post" name="pro">
  <div class="form-input-title">Website</div>
  <input type="text" class="text-input-box" name="website" value="<?= htmlspecialchars($row['website'] ?? '') ?>">

  <div class="form-input-title">Email Address</div>
  <input type="text" class="text-input-box" name="email" value="<?= htmlspecialchars($row['email'] ?? '') ?>">

  <div class="form-input-title">Telephone</div>
  <input type="text" class="text-input-box" name="telephone" value="<?= htmlspecialchars($row['telephone'] ?? '') ?>">

  <input type="submit" name="btnproj" class="sub_btn" value="Save Informations" hidden>
</form>
</div>
</div>
</div>
</div>
</div>
</div>
</body>
</html>
