<?php
session_start();
include('script/condb.php'); // your DB connection; used only for API file, page doesn't use it directly

/* ---------- Resolve project ID ---------- */
$PID = $_GET['project_ref'] ?? $_POST['pid'] ?? $_SESSION['pid'] ?? '';
if (!empty($PID)) {
    $_SESSION['pid'] = $PID;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Dashboard</title>
  <script src="foundation-duplicate.js"></script>
<script src="https://unpkg.com/lucide@latest"></script>
<link href="css/layout.css" rel="stylesheet" type="text/css">
</head>
<body>
<!-- App Loader -->
<div id="app-loader">
  <div class="loader-inner">
    <div class="loader-ring"></div>
    <div class="loader-text">Loading workspace…</div>
  </div>
</div>
<!-- App Loader Ends-->
	
<!-- Network Status Toast -->
<div id="network-status" class="network-toast hidden">
  <span class="dot"></span>
  <span class="message">You are offline</span>
</div>
<!-- Network Status Toast Ends -->
	
  <div class="app-layout">
    <aside class="nav left-nav">
      <!-- LEFT NAV CONTENT -->
<div class="right-nav-panel">
<!--Stages of Project Button Starts-->
	<nav class="sidebar"><ul><li><a href="#"><i data-lucide="layers"></i> Project Stages</a></li></ul></nav>
	<div id="dynamic-stages"></div>

<!--Stages of Project Button Starts
  <button class="right-nav-btn">Ground Beam with Pads &amp; Raft Walls</button>
  <button class="right-nav-btn">Foundation Copping</button>
  <button class="right-nav-btn">Plastering</button>-->
</div>	
    </aside>

    <main class="main-content">
      <!-- CENTER CONTENT -->
	
    </main>

    <aside class="nav right-nav">
      <!-- RIGHT NAV CONTENT -->
<nav class="sidebar">
      <ul>
		  <li class="logo"><img src="images/logo.png" width="286" height="152" alt=""/></li>
        <li><a href="#"><i data-lucide="home"></i> Dashboard</a></li>
        <li><a href="#"><i data-lucide="settings"></i>Settings</a></li>
		<li><a href="#"><i data-lucide="info"></i>Project Information</a></li>
		<li><a href="#"><i data-lucide="clipboard-check"></i>Project Control</a></li>
        <li><a href="#"><i data-lucide="package"></i>Materials</a></li>
        <li><a href="#"><i data-lucide="users"></i>Labourers</a></li>
        <li><a href="#"><i data-lucide="wrench"></i>Equipment</a></li>
        <li><a href="#"><i data-lucide="file-text"></i>Cost Estimate</a></li>
        <li><a href="#"><i data-lucide="file-text"></i>BOQ</a></li>
		<li class="version-id">Version 1.0</li>
      </ul>
    </nav>

    </aside>
  </div>
	  
<!-- Modal Box starts -->
  <div id="modal" class="modal">
    <div class="modal-box">
      <button class="close-btn" onclick="closeModal()">×</button>
      <div id="modal-body"></div>
    </div>
  </div>


  <!-- Modal stays here -->
  <div id="modal" class="modal">
    <div class="modal-box">
      <button class="close-btn" onclick="closeModal()">×</button>
      <div id="modal-body"></div>
    </div>
  </div>

      <!-- Modal -->
      <div id="modal" class="modal">
        <div class="modal-box">
          <button class="close-btn" onclick="closeModal()">×</button>
          <div id="modal-body"></div>
        </div>
      </div>
  </div>
  <script src="script.js"></script>
	
<!--JS For Lucide Icons-->
<script>
  lucide.createIcons();
</script>
	
<!--JS For Page Loader-->
<script>
  window.addEventListener("load", () => {
    const loader = document.getElementById("app-loader");

    setTimeout(() => {
      loader.classList.add("fade-out");
    }, 1900); // small delay = premium feel
  });
</script>

<!--JS For Network Detection-->
<script>
  const toast = document.getElementById("network-status");
  const message = toast.querySelector(".message");

  function showOffline() {
    message.textContent = "You are offline";
    toast.classList.remove("online", "hidden");
  }

  function showOnline() {
    message.textContent = "Back online";
    toast.classList.add("online");
    toast.classList.remove("hidden");

    // Auto-hide after a moment
    setTimeout(() => {
      toast.classList.add("hidden");
    }, 3000);
  }

  // Initial state
  if (!navigator.onLine) {
    showOffline();
  }

  // Events
  window.addEventListener("offline", showOffline);
  window.addEventListener("online", showOnline);
</script>

</body>
</html>
