const modalContents = {
  
	
  "Settings": " <h3 class='modal-section-header' >Settings</h3><div class='accordion'><div class='accordion-item'><button class='accordion-header'><span>Unit System</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Your info here</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Currency Settings</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here.</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Printout Settings</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>My Subscription</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here.</p></div></div> ",
	
  "Project Stages": " <h3 class='modal-section-header' >Project Stages</h3><div class='accordion'><div class='accordion-item'><button class='accordion-header'><span>Foundation</span><i class='chevron'>▸</i></button><div class='accordion-content'><form><div class='form-row'><input type='checkbox' data-file='foundation_form.php' class='form-check'><input type='text' class='form-input' placeholder='Foundation'></div><div class='form-row'><input type='checkbox' data-file='foundation_groundbeam_2.php' class='form-check'><input type='text' class='form-input' placeholder='Ground Beam with Pads and Raft Walls'></div><div class='form-row'><input type='checkbox' data-file='foundation_copping_2.php' class='form-check'><input type='text' class='form-input' placeholder='Foundation Copping'></div><div class='form-row'><input type='checkbox' data-file='foundation_sandfilling.php' class='form-check'><input type='text' class='form-input' placeholder='Foundation Sand Filling & Others'></div><div class='form-row'><input type='checkbox' data-file='foundation_germanfloor.php' class='form-check'><input type='text' class='form-input' placeholder='Oversite or German Concrete'></div></form></div></div> <div class='accordion-item'><button class='accordion-header'><span>Floor Stages</span><i class='chevron'>▸</i></button><div class='accordion-content'><form><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='First Floor'><input type='text' class='form-input' placeholder='First Floor Slab/Decking'></div><div class='form-btn-add'>+ Add Extra Floor</div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Floor to Roofing Level'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Parapet'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Kitchen Slab'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Gable Walls'></div></form></div></div> <div class='accordion-item'><button class='accordion-header'><span>Roofing</span><i class='chevron'>▸</i></button><div class='accordion-content'><form><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Wood Work & Properties'><input type='text' class='form-input' placeholder='Roofing Sheet Work & Properties'></div></form></div></div> <div class='accordion-item'><button class='accordion-header'><span>Other Works</span><i class='chevron'>▸</i></button><div class='accordion-content'><form><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Fencing'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Soak Away Pit & Septic Tank'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Electrical Piping'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Home Automation Piping'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='CCTV Piping'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Plumbing Piping'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='AC Line Piping'></div></form></div></div> <div class='accordion-item'><button class='accordion-header'><span>Finishes</span><i class='chevron'>▸</i></button><div class='accordion-content'><form><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Plastering'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Windows & Doors'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Black POP Work for Windows, Beams & Others'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Electrical Wiring'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Home Automation Wiring'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='CCTV Wiring'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Ceiling POP'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Screeding'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Tiling Work'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Painting'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Electrical Fittings'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Home Automation Controllers & Devices'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='CCTV Devices'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Plumbing Last Stage Piping'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='Plumbing Fittings'></div><div class='form-row'><input type='checkbox' class='form-check'><input type='text' class='form-input' placeholder='AC Inner Piping & Installation'></div></form></div></div>",
	
  "Project Control": " <h3 class='modal-section-header' >Project Control</h3><div class='accordion'><div class='accordion-item'><button class='accordion-header'><span>Data 1</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Your info here</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Data 2</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here.</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Data 3</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Data 4</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here.</p></div></div> ",
	
  "Equipment": " <h3 class='modal-section-header' >Equipments</h3><div class='accordion'><div class='accordion-item'><button class='accordion-header'><span>Unit System</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Your info here</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Currency Settings</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here.</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Printout Settings</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>My Subscription</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here.</p></div></div> ",
	
  "Materials": " <h3 class='modal-section-header' >Materials</h3><div class='accordion'><div class='accordion-item'><button class='accordion-header'><span>Blocks</span><i class='chevron'>▸</i></button><div class='accordion-content'><form><div class='grid head'>        <div>Names</div><div>Widths</div><div>Lenghts</div><div>Heights</div><div>Mortar's</div><div>Prices</div><div>Down-Labour's</div><div>Up-Labour's</div><div>Height of a Course's</div></div></form></div></div> <div class='accordion-item'><button class='accordion-header'><span>Planks, Woods & Others</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details about planning stage.</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Steels & Binding Wires</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details about planning stage.</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Cement, Sand & Gravel</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details about planning stage.</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Roofing Woods</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details about planning stage.</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Roofing Types & Properties</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details about planning stage.</p></div></div>",
	
  "Labourers": " <h3 class='modal-section-header' >Labourers</h3><div class='accordion'><div class='accordion-item'><button class='accordion-header'><span>Data 1</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Your info here</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Data 2</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here.</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Data 3</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here</p></div></div> <div class='accordion-item'><button class='accordion-header'><span>Data 4</span><i class='chevron'>▸</i></button><div class='accordion-content'><p>Details Here.</p></div></div> ",
	
  "Cost Estimate": " <h3 class='modal-section-header' >Cost Estimate</h3><div class='accordion'><p>Details Here.</p> ",
	
  "BOQ": " <h3 class='modal-section-header' >BOQ</h3><div class='accordion'><p>Details Here.</p> ",
	
  "Project Information": " <h3 class='modal-section-header' >Project Information</h3><div class='accordion'><p>Details Here.</p> ",
};

document.querySelectorAll('.sidebar a').forEach(link=>{
  link.addEventListener('click',(e)=>{
    e.preventDefault();
    const key=link.textContent.trim();
    const modalBody=document.getElementById('modal-body');
    modalBody.innerHTML=modalContents[key] || "<p>No content defined for this section.</p>";
    openModal();
  });
});

function openModal(){document.getElementById('modal').style.display='block';}
function closeModal(){document.getElementById('modal').style.display='none';}

document.addEventListener('click',function(e){
  if(e.target.closest('.accordion-header')){
    let header=e.target.closest('.accordion-header');
    let item=header.parentElement;
    document.querySelectorAll('.accordion-item').forEach(i=>{if(i!==item)i.classList.remove('active');});
    item.classList.toggle('active');
  }
});
// === MAKE MODAL DRAGGABLE (NO JUMPING + NO RESIZE) ===
(function () {
    const modalBox = document.querySelector('.modal-box');
    if (!modalBox) return;

    let isDragging = false;
    let offsetX = 0;
    let offsetY = 0;

    // Read CSS-computed size once
    const modalStyles = window.getComputedStyle(modalBox);
    const modalWidth = modalStyles.width;
    const modalHeight = modalStyles.height;

    // Apply fixed width/height from CSS so it doesn't change on drag
    modalBox.style.width = modalWidth;
    modalBox.style.height = modalHeight;

    modalBox.addEventListener('mousedown', function (e) {
        // Prevent dragging when clicking inputs or form elements
        if (["INPUT","BUTTON","SELECT","TEXTAREA"].includes(e.target.tagName)) return;

        isDragging = true;

        const rect = modalBox.getBoundingClientRect();
        offsetX = e.clientX - rect.left;
        offsetY = e.clientY - rect.top;

        modalBox.style.position = "fixed";
        modalBox.style.left = rect.left + "px";
        modalBox.style.top = rect.top + "px";
        modalBox.style.margin = "0";
        modalBox.style.transform = "none";

        document.body.style.userSelect = "none";
    });

    document.addEventListener('mousemove', function (e) {
        if (!isDragging) return;

        modalBox.style.left = (e.clientX - offsetX) + "px";
        modalBox.style.top = (e.clientY - offsetY) + "px";
    });

    document.addEventListener('mouseup', function () {
        isDragging = false;
        document.body.style.userSelect = "auto";
    });
})();


/* ============================================================
   DYNAMIC PROJECT STAGES GENERATOR (FRONT-END ONLY)
============================================================ */

document.addEventListener("change", function (e) {

    // Only target checkboxes inside project stage forms
    if (e.target.classList.contains("form-check")) {

        const row = e.target.closest(".form-row");
        const textInput = row.querySelector(".form-input");

        if (!textInput) return;

        const stageName = textInput.value.trim();

        // If checkbox is checked but textbox empty
        if (e.target.checked && stageName.length === 0) {
            alert("Enter a stage name before checking the box.");
            e.target.checked = false;
            return;
        }

        // Create safe filename
        const fileName = e.target.dataset.file;

        if (e.target.checked) {
            addStageButton(stageName, fileName);
        } else {
            removeStageButton(stageName);
        }
    }
});


/* ============================================================
   CREATE NEW STAGE BUTTON
============================================================ */
function addStageButton(label, file) {
    const container = document.getElementById("dynamic-stages");

    // Prevent duplicates
    if (document.querySelector(`[data-stage='${label}']`)) return;

    const btn = document.createElement("button");
    btn.className = "right-nav-btn";
    btn.dataset.stage = label;
    btn.dataset.file = file;
    btn.textContent = label;

    btn.addEventListener("click", function () {
        loadStagePage(file);
    });

    container.appendChild(btn);
}


/* ============================================================
   REMOVE STAGE BUTTON WHEN UNCHECKED
============================================================ */
function removeStageButton(label) {
    const btn = document.querySelector(`[data-stage='${label}']`);
    if (btn) btn.remove();
}


/* ============================================================
   LOAD SELECTED PAGE INTO MAIN CONTENT
============================================================ */
function loadStagePage(file) {
    fetch(file)
        .then(resp => resp.text())
        .then(html => {
            document.querySelector(".main-content").innerHTML = html;
        })
        .catch(err => {
            document.querySelector(".main-content").innerHTML =
                `<p style="color:red; padding:20px;">Cannot load ${file}</p>`;
        });
}
