<?php
session_start();
include('script/condb.php'); // DB connection

// Optional: capture project_ref if passed
$PID = $_GET['project_ref'] ?? $_POST['pid'] ?? $_SESSION['pid'] ?? '';
if (!empty($PID)) {
    $_SESSION['pid'] = $PID;
}

/* Pre-build options for JS templates (equipment only) */
$equipmentOptions = '';
$prod_eq = "SELECT construction_equipmentName FROM upline_app_construction_equipment";
$que_eq = mysqli_query($con, $prod_eq);
while ($rec_eq = mysqli_fetch_assoc($que_eq)) {
    $name = htmlspecialchars($rec_eq['construction_equipmentName']);
    $equipmentOptions .= '<option value="'.$name.'">'.$name.'</option>';
}
?>
<?php
//----------------------block fromDB----------------------------
//--------------------------------------------------------------
$blockOptions = "";
$prod = "SELECT Block_name FROM upline_app_blocksettings";
    $que2 = mysqli_query($con, $prod);
    while($rec2 = mysqli_fetch_array($que2)){
        $blockOptions .= '<option value="'.$rec2['Block_name'].'">'.$rec2['Block_name'].'</option>';
    }


//--------------------------Planks from DB----------------------
//-------------------------------------------------------------
$plankOptions = "";

$prod_plank = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='plank'";
$que_plank = mysqli_query($con, $prod_plank);

while($rec_plank = mysqli_fetch_array($que_plank)){
    $plankOptions .= '<option value="'.$rec_plank['plankothers_name'].'">'.$rec_plank['plankothers_name'].'</option>';
}
//--------------------------woods from DB----------------------
//-------------------------------------------------------------
$woodOptions ="";
$prod_wood = "SELECT plankothers_name FROM upline_app_plankothers WHERE plankothers_type='wood'";
            $que_wood = mysqli_query($con, $prod_wood);
            while($rec_wood = mysqli_fetch_array($que_wood)){
               $woodOptions .= '<option value="'.$rec_wood['plankothers_name'].'">'.$rec_wood['plankothers_name'].'</option>';
            }
            
    //--------------steel from DB----------------------------
    //-------------------------------------------------------
 $steelOptions ="";
 $prod_steel = "SELECT steels_wire_name FROM upline_app_steels_wire WHERE steels_wire_type='steel'";
            $que_steel = mysqli_query($con, $prod_steel);
            while($rec_steel = mysqli_fetch_array($que_steel)){
               $steelOptions .= '<option value="'.$rec_steel['steels_wire_name'].'">'.$rec_steel['steels_wire_name'].'</option>';
            }
   //------------------------------Concete from DB-----
   //--------------------------------------------------
   
   $concreteOptions ="";
   $prod_con1 = "SELECT Mixed_Ratio_Name FROM upline_app_concretework";
            $que_con1 = mysqli_query($con, $prod_con1);
            while($rec_con1 = mysqli_fetch_array($que_con1)){
                $concreteOptions .= '<option value="'.$rec_con1['Mixed_Ratio_Name'].'">'.$rec_con1['Mixed_Ratio_Name'].'</option>';
            }
            
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Foundation Form</title>
</head>
<body style="font-family:Arial; background:#e5edf7; padding:20px;">

<div class="container">
<div style="width:100%;background:#f7c4c4;color:#4a0000;font-weight:bold;text-align:left;padding-left:14px;padding-bottom:6px;padding-top:6px;margin-bottom:10px;border-radius:4px;font-size:16px;">
    FOUNDATION
  </div>


<!-- === 1. Walls === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

  <!-- HEADER -->
  <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:4px;">

      <!-- Checkbox -->
      <label style="display:flex;align-items:center;gap:6px;margin:0;">
          <input type="checkbox">
          <span style="color:#900;font-weight:bold;user-select:none;">Walls</span>
      </label>

      <!-- Refresh button -->
      <button id="refreshWallSectionBtn"
          style="
              padding:3px 8px;
              background:#103049;
              color:white;
              border:none;
              border-radius:4px;
              cursor:pointer;
              font-size:13px;
              margin-top:-2px;
              margin-right:0;
          ">
          Refresh
      </button>
  </div>

  <!-- TOP LABELS -->
  <div style="
        display:flex;
        gap:6px;
        font-size:12px;
        font-weight:bold;
        color:#103049;
        margin-bottom:4px;
  ">
      <div style="width:190px; user-select:none;">Wall Name</div>
      <div style="width:190px; user-select:none;">Wall Size & Type</div>
      <div style="width:80px; user-select:none;">Length</div>
      <div style="width:80px; user-select:none;">Course</div>
      <div style="width:80px; user-select:none;">Height</div>
  </div>

  <style>
      .wall-input {
          width:100%;
          height:24px;
          font-size:13px;
          padding:3px 5px;
          border:1px solid #7f9bbd;
          border-radius:4px;
          background:#fff;
          box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
      }
      .wall-select {
          width:100%;
          height:24px;
          font-size:13px;
          padding:3px 5px;
          border:1px solid #7f9bbd;
          border-radius:4px;
          background:#f8f8f8;
          color:#777;
          box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
      }
      .wall-height {
          background:#f0f0f0;
          color:#666;
      }
  </style>

  <!-- FIXED SPACING: ROW STYLE -->
  <div class="row" style="display:flex;gap:6px;margin-bottom:6px;">
      <input type="text" placeholder="Exterior Walls" class="wall-input" style="width:190px;">
      <select class="wall-select" style="width:190px;"><?php echo $blockOptions; ?></select>
      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
      <input type="text" placeholder="Course" class="wall-input" style="width:80px;">
      <input type="text" placeholder="Height" class="wall-input wall-height" style="width:80px;">
  </div>

  <div class="row" style="display:flex;gap:6px;margin-bottom:6px;">
      <input type="text" placeholder="Interior Walls" class="wall-input" style="width:190px;">
      <select class="wall-select" style="width:190px;"><?php echo $blockOptions; ?></select>
      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
      <input type="text" placeholder="Course" class="wall-input" style="width:80px;">
      <input type="text" placeholder="Height" class="wall-input wall-height" style="width:80px;">
  </div>

  <div class="row" style="display:flex;gap:6px;">
      <input type="text" placeholder="Other Interior Walls" class="wall-input" style="width:190px;">
      <select class="wall-select" style="width:190px;"><?php echo $blockOptions; ?></select>
      <input type="text" placeholder="Length" class="wall-input" style="width:80px;">
      <input type="text" placeholder="Course" class="wall-input" style="width:80px;">
      <input type="text" placeholder="Height" class="wall-input wall-height" style="width:80px;">
  </div>

</div>

  
<!-- === 2. Starter Columns & Base === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

  <!-- TITLE + CHECKBOX (reduced spacing) -->
  <div style="display:flex;gap:12px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Columns</span>
        </label>
  </div>

  <!-- Reduced extra gap -->
  <div style="height:4px;"></div>

  <!-- Numbers -->
  <div style="display:flex;align-items:center;gap:4px;margin-bottom:6px;">
      <input type="text" placeholder="16"
             style="width:70px;height:24px;background:#ffcccc;
                    border:1px solid #b33;padding:2px 6px;font-size:14px;">
      <span style="color:#103049;font-size:12px; user-select:none; font-weight:600;">Numbers</span>
  </div>

  <!-- Heights -->
  <div style="display:flex;align-items:center;gap:4px;margin-bottom:6px;">
      <input type="text" placeholder="1.25"
             style="width:70px;height:24px;background:#ffcccc;
                    border:1px solid #b33;padding:2px 6px;font-size:14px;">
      <span style="color:#103049;font-size:12px;user-select:none;font-weight:600;">Heights</span>
  </div>


<!-- Embossed Input Style -->
<style>
.starter-input {
    width:100%;
    height:24px;
    font-size:14px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#fff;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
.starter-select {
    width:100%;
    height:24px;
    font-size:14px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#f8f8f8;
    color:#777;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
</style>

  <!-- COLUMN TYPE CONTAINER -->
  <div id="columnTypeContainer">

      <!-- FIRST ROW (reduced spacing) -->
      <div class="row column-type-row" 
           style="display:flex;gap:6px;margin-bottom:6px;align-items:flex-start;">

          <!-- Number -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Number</label>
              <input type="text" class="starter-input" placeholder="Number" 
                     style="width:65px;">
          </div>

          <!-- Length -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Length</label>
              <input type="text" class="starter-input" placeholder="Length" 
                     style="width:70px;">
          </div>

          <!-- Width -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Width</label>
              <input type="text" class="starter-input" placeholder="Width" 
                     style="width:70px;">
          </div>

          <!-- Bar Type -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Bar Type</label>
              <select class="starter-select" style="width:100px;">
                  <?php echo $steelOptions; ?>
              </select>
          </div>

          <!-- Bar Numbers -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold;user-select:none;">Bar Num.</label>
              <input type="text"  class="starter-input" placeholder="Bar Num." 
                     style="width:70px;">
          </div>

          <!-- Cut Steel Into -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px; user-select:none;">A Steel to</label>
              <input type="text" class="starter-input" placeholder="A Steel to" 
                     style="width:70px;">
          </div>

          <!-- Stirrups -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Stirrups</label>
              <input type="text" class="starter-input" placeholder="Stirrups" 
                     style="width:70px;">
          </div>

          <!-- Stirrup Type -->
          <div style="display:flex;flex-direction:column;">
              <label style="font-size:12px;color:#103049;margin-bottom:2px; user-select:none;">Stirrup Type</label>
              <select class="starter-select" style="width:100px;">
                  <?php echo $steelOptions; ?>
              </select>
          </div>

      </div>

  </div>

<button type="button" onclick="addColumnTypeRow()"
  style="margin-top:6px;padding:6px 12px;background:#103049;color:white;border:none;border-radius:4px;cursor:pointer;font-size:14px;">
  + Add More
</button> 

</div>


<!-- === COLUMN BASES === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

  <div class="section-title" style="font-weight:bold;color:#103049;margin-bottom:6px;">

    <!-- TOP CHECKBOXES -->
    <div style="display:flex;gap:14px;margin-bottom:6px;">
        <label style="display:flex;align-items:center;">
            <input type="checkbox">
            <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
                Columns Base
            </span>
        </label>

        <label style="display:flex;align-items:center;">
            <input type="checkbox">
            <span style="color:#0047b3;font-weight:bold;font-size:12px;margin-left:4px; user-select:none;">
                Include Bending
            </span>
        </label>
    </div>

    <!-- COLUMN BASE COUNT -->
    <div style="display:flex;align-items:center;gap:4px;margin-bottom:6px;">
        <input type="text" placeholder="16"
               style="width:70px;height:24px;background:#ffcccc;
                      border:1px solid #b33;padding:2px 6px;font-size:14px;">
        <span style="color:#103049;font-size:12px;user-select:none;">
            Numbers
        </span>
    </div>

    <!-- HEADERS ROW -->
    <div style="
        display:flex;
        gap:6px;
        margin-bottom:4px;
        font-size:13px;
        font-weight:bold;
        color:#103049;
        user-select:none;
    ">
        <div style="width:70px;">Numbers</div>
        <div style="width:70px;">Width</div>
        <div style="width:70px;">Height</div>
        <div style="width:100px;">Bar Types</div>
        <div style="width:70px;">Bar Num</div>
        <div style="width:120px;">Mat Types</div>
        <div style="width:70px;">Bending Ht</div>
    </div>

<style>
.cbase-input {
    width:100%;
    height:24px;
    font-size:14px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#fff;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
.cbase-select {
    width:100%;
    height:24px;
    font-size:12px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#f8f8f8;
    color:#777;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
</style>

<!-- BASE ROWS CONTAINER -->
<div id="columnBaseContainer">

    <!-- FIRST ROW -->
    <div class="column-base-row"
         style="display:flex;gap:6px;align-items:center;margin-bottom:6px;">

        <input type="text" class="cbase-input" placeholder="16" style="width:70px;">

        <input type="text" class="cbase-input" placeholder="1" style="width:70px;">

        <input type="text" class="cbase-input" placeholder="0.15" style="width:70px;">

        <select class="cbase-select" style="width:100px;">
            <?php echo $steelOptions; ?>
        </select>

        <input type="text" class="cbase-input" placeholder="14" style="width:70px;">

        <select class="cbase-select" style="width:120px;">
            <option>Single Mat</option>
            <option selected>Double Mat</option>
        </select>

        <input type="text" class="cbase-input" value="0.1"
               style="width:70px;border:1px solid #7aaaff;background:#e8f1ff;color:#0040a0;">
    </div>

</div>

<button type="button" onclick="addColumnBaseRow()"
        style="
            margin-top:4px;
            padding:6px 12px;
            background:#103049;
            color:white;
            border:none;
            border-radius:4px;
            cursor:pointer;
            font-size:14px;
        ">
    + Add More
</button>

</div></div>


<div style="width:100%;background:#f7c4c4;color:#4a0000;font-weight:bold;text-align:left;padding-left:16px;padding-bottom:6px;padding-top:6px;margin:10px 0;border-radius:4px;font-size:16px;">
    PROPERTIES
  </div>
<!-- === 3. Partition in Trench === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

       /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">

  <!-- <div class="section-title" style="font-weight:bold;color:#103049;margin-bottom:10px;">
      <div style="font-weight:bold;font-size:18px;color:#103049;margin-bottom:6px;">
        Partition in Trench
    </div>
       DIVIDER LINE 
    <div style="border-bottom:2px solid #103049;margin-bottom:12px;"></div>
    <input type="checkbox"><span style="color:#900;font-weight:bold;"> Partition in Trench </span>-->
    <div style="display:flex;gap:20px;margin-bottom:12px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Partitions in Trench</span>
        </label>

  </div>
  <!-- Embossed Input Style -->
<style>
.partition-input {
    width:100%;
    height:24px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    font-size:14px;
    background:#fff;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
.partition-select {
    width:100%;
    height:24px;
    font-size:14px;
    padding:3px 6px;
    border:1px solid #7f9bbd;
    border-radius:4px;
    background:#f8f8f8;
    color:#777;
    box-shadow:inset 0 1px 2px rgba(0,0,0,0.25);
}
.partition-height {
    background:#f0f0f0;
    color:#666;
}
</style>
  <div class="row" style="display:flex;gap:6px;margin-bottom:10px;align-items:flex-start;">

    <!-- LENGTH -->
    <div style="display:flex;flex-direction:column;">
        <label style="font-size:12px;color:#103049;margin-bottom:2px; font-weight:bold; user-select:none;">Length</label>
        <input class="partition-input" type="text" placeholder="Length"
               style="width:120px;height:24px;padding:4px 8px; font-weight:300;font-size:14px;">
    </div>

    <!-- WIDTH -->
    <div style="display:flex;flex-direction:column;">
        <label style="font-size:12px;color:#103049;margin-bottom:2px; font-weight:bold; user-select:none;">Width</label>
        <input type="text" class="partition-input" placeholder="Width"
               style="width:120px;height:24px;padding:4px 8px;">
    </div>

    <!-- DEPTH -->
    <div style="display:flex;flex-direction:column;">
        <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Depth</label>
        <input type="text" class="partition-input" placeholder="Depth"
               style="width:120px;height:24px;padding:4px 8px;">
    </div>

</div>

</div>

<!-- === 4. Blocks & Mortar === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- BLOCKS & MORTAR CHECKBOX -->
    <div style="display:flex;gap:20px;margin-bottom:6px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Blocks & Mortars</span>
        </label>
    </div>


    <!-- CEMENT MORTAR RATIO (NOW IMMEDIATELY UNDER CHECKBOX) -->
    <div style="
        font-size:13px;
        color:white;
        font-weight:bold;
        font-style:italic;
        margin-bottom:6px;
        user-select:none;
    ">
        Cement Mortar Ratio
    </div>


    <!-- CEMENT + SAND FIELDS DIRECTLY UNDER RATIO LABEL -->
    <div style="display:flex;gap:6px;margin-bottom:10px;">

        <!-- CEMENT -->
        <div style="display:flex;flex-direction:column;">
            <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Cement</label>
            <input type="text" class="cbase-input" placeholder="Cement"
                   style="width:120px;height:24px;padding:3px 6px;">
        </div>

        <!-- SAND -->
        <div style="display:flex;flex-direction:column;">
            <label style="font-size:12px;color:#103049;margin-bottom:2px;font-weight:bold; user-select:none;">Sand</label>
            <input type="text" class="cbase-input" placeholder="Sand"
                   style="width:120px;height:24px;padding:3px 6px;">
        </div>

    </div>

</div>

<!-- === 5. Planks === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">

<!--<div class="section" style="background:#b8c7d9;padding:12px;margin-bottom:18px;border-left:4px solid #f4d03f;border-radius:6px;">
  <div class="section-title" style="font-weight:bold;color:#103049;margin-bottom:12px;">
      <div style="font-weight:bold;font-size:18px;color:#103049;margin-bottom:6px;">
        Planks
    </div>
        DIVIDER LINE 
    <div style="border-bottom:2px solid #103049;margin-bottom:12px;"></div>
    <input type="checkbox"> <span style="color:#900;font-weight:bold;"> Planks </span>-->
    <div style="display:flex;gap:20px;margin-bottom:12px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Planks</span>
        </label>

  </div>
  <!-- WOOD TYPE ROW (LABEL + FIELDS + CHECKBOX LABELS) -->
<div class="row" style="display:flex;align-items:flex-start;gap:12px;margin-bottom:12px;">

  <!-- LEFT LABEL ON SAME LINE
  <div style="font-size:14px;font-weight:bold;color:#103049;min-width:120px;margin-top:18px; user-select:none;">
    Wood Type
  </div> -->

  <!-- FIELDS + TOP CHECKBOX LABELS -->
  <div style="display:flex;gap:6px;">

      <!-- FIRST COLUMN (Checkbox + Dropdown) -->
      <div style="display:flex;flex-direction:column;">
        
        <!-- Checkbox label IN BLUE -->
        <label style="font-size:12px;color:#0047b3;font-weight:bold;margin-bottom:2px; user-select:none;">
            <input type="checkbox" style="margin-right:4px; user-select:none;">
            Plank for column bases
        </label>

        <!-- Dropdown -->
        <select  class="cbase-select" style="width:200px;height:24px;padding:4px 8px;color:#777;background:#f7f7f7;">
          <option value="">Select Plank</option>
          <?php
          echo $plankOptions;
          ?>
        </select>

      </div>


      <!-- SECOND COLUMN (Checkbox + Dropdown) -->
      <div style="display:flex;flex-direction:column;">
        
        <!-- Checkbox label IN BLUE -->
        <label style="font-size:12px;color:#0047b3;font-weight:bold;margin-bottom:2px; user-select:none;">
            <input type="checkbox" style="margin-right:4px; user-select:none;">
            Plank for columns
        </label>

        <!-- Dropdown -->
        <select class="cbase-select" style="width:200px;height:24px;padding:4px 8px;color:#777;background:#f7f7f7;">
          <option value="">Select Plank</option>
          <?php
          echo $plankOptions;
          ?>
        </select>

      </div>

  </div>

</div></div>


<!-- === 6. Woods === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <!-- MAIN CHECKBOX -->
    <div class="section-title" 
         style="
            font-weight:bold;
            color:#103049;
            margin-bottom:4px;
            display:flex;
            align-items:center;
            gap:25px;
         ">
        <label style="display:flex;align-items:center;">
            <input type="checkbox">
            <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
                Woods
            </span>
        </label>
    </div>

    <!-- MOVED DOWN: Wood for Column Bracing (Italic White) -->
    <div style="
        margin-left:0px;
        margin-bottom:8px;
        font-style:italic;
        color:white;
        font-size:13px;
        font-weight:bold;
        user-select:none;
    ">
        Wood for Column Bracing
    </div>


    <!-- ======================================= -->
    <!-- 1) BUILD ALONG CHECKBOX -->
    <!-- ======================================= -->
    <label style="display:flex;align-items:center;margin-bottom:6px;margin-left:0px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.85);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Build Along
        </span>
    </label>


    <!-- TOP LABELS -->
    <div style="display:flex;gap:6px;margin-bottom:4px;
                font-size:12px;color:#103049;font-weight:bold;">
        <div style="width:200px; user-select:none;">Wood Type</div>
        <div style="width:120px; user-select:none;">Length</div>
        <div style="width:120px; user-select:none;">Number</div>
    </div>

    <!-- INPUT FIELDS -->
    <div style="display:flex;gap:6px;margin-bottom:14px;">
        <select class="cbase-select" style="width:200px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;">
            <option value="">Select Wood</option>
            <?php echo $woodOptions; ?>
        </select>

        <input type="text" class="cbase-input" placeholder="Length" 
               style="width:120px;height:24px;padding:4px 6px;">

        <input type="text" class="cbase-input" placeholder="Number" 
               style="width:120px;height:24px;padding:4px 6px;">
    </div>




    <!-- ======================================= -->
    <!-- 2) FRAME STRUCTURE CHECKBOX -->
    <!-- ======================================= -->
    <label style="display:flex;align-items:center;margin-bottom:6px;">
        <input type="checkbox" style="margin-right:6px;transform:scale(0.85);">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
           Frame Structure
        </span>
    </label>

    <!-- TOP LABELS -->
    <div style="display:flex;gap:6px;margin-bottom:4px;
                font-size:12px;color:#103049;font-weight:bold;">
        <div style="width:200px; user-select:none;">Wood Type</div>
        <div style="width:120px;user-select:none;">Spacing</div>
    </div>

    <!-- INPUT FIELDS -->
    <div style="display:flex;gap:6px;">

        <select class="cbase-select" style="width:200px;height:24px;padding:4px 6px;color:#777;background:#f7f7f7;">
            <option value="">Select Wood</option>
            <?php echo $woodOptions; ?>
        </select>

        <input type="text" class="cbase-input" placeholder="Spacing" 
               style="width:120px;height:24px;padding:4px 6px;">
    </div>

</div>


<!-- === 7. Stirrups === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

    <div style="display:flex;gap:20px;margin-bottom:12px;">

        <label style="margin-top:10px;">   <!-- ✔️ moved slightly downward -->
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Stirrups</span>
        </label>

    </div>

</div>

<!-- === 8. Bars === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;
        border-left:4px solid #f4d03f;
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),
            inset 0 -2px 4px rgba(0,0,0,0.15);
     ">

  <!-- CHECKBOX ROW -->
  <div class="section-title" 
       style="
            font-weight:bold;
            color:#103049;
            margin-bottom:6px;
            display:flex;
            align-items:center;
            position:relative;
            height:24px;
            margin-top:10px;
       ">

      <!-- MAIN CHECKBOX -->
      <label style="display:flex;align-items:center;position:absolute;left:0;">
          <input type="checkbox" style="margin-right:6px;">
          <span style="color:#900;font-weight:bold;user-select:none;">Bars</span>
      </label>

      <!-- Bars for Column Bases → EXACTLY above Concrete Grade -->
      <label style="
          display:flex;
          align-items:center;
          position:absolute;
          left:126px;   /* ✔ EXACT alignment with Concrete Grade */
          top:2px;
      ">
          <input type="checkbox" style="margin-right:6px;transform:scale(0.85);">
          <span style="color:#0047b3;font-weight:bold;font-size:12px;user-select:none;">
              Bars for Column Bases
          </span>
      </label>

      <!-- Bars for Entire Columns → EXACTLY above Cement -->
      <label style="
          display:flex;
          align-items:center;
          position:absolute;
          left:292px;   /* ✔ EXACT alignment with Cement */
          top:2px;
      ">
          <input type="checkbox" style="margin-right:6px;transform:scale(0.85);">
          <span style="color:#0047b3;font-weight:bold;font-size:12px;user-select:none;">
              Bars for Entire Columns
          </span>
      </label>

  </div>

</div>



<!-- === 9. Concrete === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

       /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


   <!-- MAIN TITLE + CHECKBOXES -->
    <div class="section-title" 
         style="font-weight:bold;color:#103049;margin-bottom:10px;
                display:flex;align-items:center;position:relative;height:24px;">

        <!-- MAIN CHECKBOX -->
        <label style="display:flex;align-items:center;position:absolute;left:0;">
            <input type="checkbox">
            <span style="color:#900;font-weight:bold;margin-left:6px; user-select:none;">
                Concretes
            </span>
        </label>

        <!-- Concrete for Column Bases — aligned with Bars for Column Bases -->
        <label style="
            display:flex;
            align-items:center;
            position:absolute;
            left:126px;   /* ✔ EXACT SAME POSITION as Bars for Column Bases */
            top:2px;
        ">
            <input type="checkbox" style="margin-right:6px;transform:scale(0.9);">
            <span style="color:#0047b3;font-weight:bold;font-size:12px;user-select:none;">
                Concrete for Column Bases
            </span>
        </label>

    </div>



    <!-- ======================================================= -->
    <!-- 1) CONCRETE FOR BLINDING — WITH TOP LABELS -->
    <!-- ======================================================= -->
    <label style="display:flex;align-items:center;margin-bottom:4px;">
        <input type="checkbox" style="margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px; user-select:none;">
            Concrete for Blinding
        </span>
    </label>

    <!-- TOP LABELS -->
    <div style="display:flex;gap:6px;margin-bottom:4px;font-size:12px;color:#103049;font-weight:bold;">
        <div style="width:120px;user-select:none;">Thickness</div>
        <div style="width:160px;user-select:none;">Concrete Grade</div>
        <div style="width:100px;user-select:none;">Cement</div>
        <div style="width:100px;user-select:none;">Sand</div>
        <div style="width:100px;user-select:none;">Gravel</div>
    </div>

    <!-- INPUT ROW -->
    <div style="display:flex;gap:6px;margin-bottom:12px;">
        <input type="text" class="cbase-input" style="width:120px;height:24px;padding:4px 6px;" placeholder="Thickness">

        <select class="cbase-select" style="width:160px;height:24px;padding:4px 6px;color:#777;background:#f8f8f8;">
            <option value="">Concrete Grade</option>
            <?php
           echo $concreteOptions;
            ?>
        </select>

        <input type="text" class="cbase-input" placeholder="Cement" style="width:100px;height:24px;padding:4px 6px;">
        <input type="text" class="cbase-input" placeholder="Sand" style="width:100px;height:24px;padding:4px 6px;">
        <input type="text" class="cbase-input" placeholder="Gravel" style="width:100px;height:24px;padding:4px 6px;">
    </div>





    <!-- ======================================================= -->
    <!-- 2) CONCRETE FOR COLUMNS — ALIGNED UNDER BLINDING -->
    <!-- ======================================================= -->
    <label style="display:flex;align-items:center;margin-bottom:4px;margin-top:6px;">
        <input type="checkbox" style="margin-right:6px;">
        <span style="color:#0047b3;font-weight:bold;font-size:12px;user-select:none;">
            Concrete for Columns
        </span>
    </label>

    <!-- TOP LABELS MATCHING SAME COLUMNS (SKIP THICKNESS COLUMN) -->
    <div style="display:flex;gap:6px;margin-bottom:4px;font-size:12px;color:#103049;font-weight:bold;padding-left:128px;">

        <!-- Padding-left pushes these labels to align under Concrete Grade column -->

        <div style="width:160px;user-select:none;">Concrete Grade</div>
        <div style="width:100px;user-select:none;">Cement</div>
        <div style="width:100px;user-select:none;">Sand</div>
        <div style="width:100px;user-select:none;">Gravel</div>
    </div>

    <!-- INPUT ROW (ALIGNED UNDER SECOND FIELD OF BLINDING) -->
    <div style="display:flex;gap:6px;margin-bottom:12px;padding-left:128px;">

        <select class="cbase-select" style="width:160px;height:24px;padding:4px 6px;color:#777;background:#f8f8f8;">
            <option value="">Concrete Grade</option>
            <?php
            echo $concreteOptions;
            ?>
        </select>

        <input type="text" class="cbase-input" placeholder="Cement" style="width:100px;height:24px;padding:4px 6px;">
        <input type="text" class="cbase-input" placeholder="Sand" style="width:100px;height:24px;padding:4px 6px;">
        <input type="text" class="cbase-input" placeholder="Gravel" style="width:100px;height:24px;padding:4px 6px;">
    </div>

</div>

<!-- === 10. Imported Bars === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


  <!-- TITLE ROW -->
  <div style="display:flex;gap:20px;margin-bottom:12px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Imported Bars</span>
        </label>

  </div>

  <!-- TOP LABELS -->
  <div style="display:flex;gap:6px;margin-bottom:4px;
              font-size:13px;font-weight:bold;color:#103049;">

      <div style="width:160px;user-select:none;">Bar Type</div>
      <div style="width:120px;user-select:none;">Total Length</div>
      <div style="width:120px;user-select:none;">Bar Quantity</div>

  </div>

  <!-- IMPORTED BARS CONTAINER -->
  <div id="importedBarsContainer">

      <!-- FIRST ROW -->
      <div class="row imported-bar-row" 
           style="display:flex;gap:6px;margin-bottom:10px;align-items:center;">

          <!-- BAR TYPE -->
          <select class="cbase-select" style="width:160px;height:24px;padding:4px 6px;
                         color:#777;background:#f7f7f7;">
              <option value="">Select Steel Size</option>
              <?php echo $steelOptions; ?>
          </select>

          <!-- TOTAL LENGTH -->
          <input type="text" class="cbase-input" placeholder="Total Length"
                 style="width:120px;height:24px;padding:4px 6px;">

          <!-- BAR QUANTITY -->
          <input type="text" class="cbase-input" placeholder="Bar Quantity"
                 style="width:120px;height:24px;padding:4px 6px;">

      </div>

  </div>

  <!-- ADD BUTTON -->
  <button type="button" onclick="addImportedBarRow()"
          style="margin-top:8px;padding:6px 12px;background:#103049;color:white;
                 border:none;border-radius:4px;cursor:pointer;font-size:14px;">
      + Add More
  </button>

</div>


<!-- === 11. Plumbing === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


  <!-- SECTION TITLE -->
  <div style="display:flex;gap:20px;margin-bottom:12px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Plumbing Piping</span>
        </label>

  </div>

  <!-- TOP LABELS -->
  <div style="display:flex;gap:6px;margin-bottom:4px;
              font-size:13px;font-weight:bold;color:#103049;">

      <div style="width:120px;user-select:none;font-weight:bold;">Materials</div>
      <div style="width:120px;user-select:none;font-weight:bold;">Labour</div>

  </div>

  <!-- INPUT FIELDS -->
  <div class="row" style="display:flex;gap:6px;">
      <input type="text" class="cbase-input" placeholder="Materials"
             style="width:120px;height:24px;padding:4px 6px;">

      <input type="text" class="cbase-input" placeholder="Labour"
             style="width:120px;height:24px;padding:4px 6px;">
  </div>

</div>


<!-- === 12. Electrical === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


  <!-- SECTION TITLE 
  <div class="section-title" 
       style="font-weight:bold;color:#103049;margin-bottom:12px;">
      <input type="checkbox">
      <span style="color:#900;font-weight:bold;">Electrical Piping</span>-->
      <div style="display:flex;gap:20px;margin-bottom:12px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; user-select:none;">Electrical Piping</span>
        </label>

  </div>

  <!-- TOP LABELS -->
  <div style="display:flex;gap:6px;margin-bottom:4px;
              font-size:13px;font-weight:bold;color:#103049;">

      <div style="width:120px;user-select:none;font-weight:bold;">Materials</div>
      <div style="width:120px;user-select:none;font-weight:bold;">Labour</div>

  </div>

  <!-- INPUT FIELDS -->
  <div class="row" style="display:flex;gap:6px;">
      <input type="text" class="cbase-input" placeholder="Materials"
             style="width:120px;height:24px;padding:4px 6px;">

      <input type="text"class="cbase-input" placeholder="Labour"
             style="width:120px;height:24px;padding:4px 6px;">
  </div>

</div>


<!-- === 13. Equipments === -->
<div class="section" 
     style="
        background:#b8c7d9;
        padding:12px;
        margin-bottom:18px;

        /* YELLOW LEFT EDGE */
        border-left:4px solid #f4d03f;

        /* EMBOSS EFFECT */
        border-radius:6px;
        box-shadow:
            inset 0 2px 4px rgba(255,255,255,0.8),  /* top highlight */
            inset 0 -2px 4px rgba(0,0,0,0.15);     /* bottom shadow */
     ">


  <!-- TITLE 
  <div class="section-title" 
       style="font-weight:bold;color:#103049;margin-bottom:12px;">
      <input type="checkbox"> 
      <span style="color:#900;font-weight:bold;"> Equipments to be Used </span>-->
      <div style="display:flex;gap:20px;margin-bottom:12px;">
        <label>
            <input type="checkbox"> 
            <span style="color:#900;font-weight:bold; ">Equipments </span>
        </label>

  </div>

  <!-- TOP LABELS -->
  <div style="display:flex;gap:6px;margin-bottom:4px;
              font-size:13px;font-weight:bold;color:#103049;">
      <div style="width:246px;user-select:none;">Equipment</div>
      <div style="width:120px;user-select:none;">Quantity</div>
  </div>

  <!-- FIRST ROW -->
  <div id="equipmentContainer">
      <div class="row equipment-row" 
           style="display:flex;gap:6px;margin-bottom:10px;align-items:center;">

          <select class="cbase-select" style="width:246px;height:24px;padding:4px 6px;
                         color:#777;background:#f8f8f8;">
              <option value="">Select Equipment</option>
              <?php echo $equipmentOptions; ?>
          </select>

          <input type="text" class="cbase-input" placeholder="Quantity"
                 style="width:120px;height:24px;padding:4px 6px;">
      </div>
  </div>

  <!-- ADD BUTTON -->
  <button type="button" onclick="addEquipmentRow()"
          style="margin-top:8px;padding:6px 12px;background:#103049;
                 color:white;border:none;border-radius:4px;cursor:pointer;font-size:14px;font-weight:300;">
      + Add More
  </button>

</div>

</div><!-- /.container -->

<script>
function removeRow(btn){
  // remove the row that contains this button
  if (btn && btn.parentElement) {
    btn.parentElement.remove();
  }
}

function addImportedBarRow(){
  var container = document.getElementById('importedBarsContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row imported-bar-row';
  row.style.cssText = 'display:flex;gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<select style="width:160px;">'
    + '  <option value="">Select Steel Size</option>'
    + '  <option>8mm</option>'
    + '  <option>12mm</option>'
    + '  <option>16mm</option>'
    + '  <option>20mm</option>'
    + '  <option>25mm</option>'
    + '</select>'
    + '<input type="text" placeholder="Total Length" style="width:140px;">'
    + '<input type="text" placeholder="Bar Quantity" style="width:140px;">'
    + '<button type="button" onclick="removeRow(this)" '
    + 'style="padding:4px 10px;background:#c0392b;color:white;border:none;border-radius:4px;cursor:pointer;">X</button>';
  container.appendChild(row);
}

function addEquipmentRow(){
  var container = document.getElementById('equipmentContainer');
  if (!container) return;
  var row = document.createElement('div');
  row.className = 'row equipment-row';
  row.style.cssText = 'display:flex;gap:6px;margin-bottom:10px;align-items:center;';
  row.innerHTML = ''
    + '<input type="text" placeholder="Quantity" style="width:120px;">'
    + '<select style="width:240px;">'
    + '  <option value="">Select Equipment</option>'
    + '  <?php echo $equipmentOptions; ?>'
    + '</select>'
    + '<button type="button" onclick="removeRow(this)" '
    + 'style="padding:4px 10px;background:#c0392b;color:white;border:none;border-radius:4px;cursor:pointer;">X</button>';
  container.appendChild(row);
}
</script>

</body>
</html>
