<?php
session_start();
include("script/condb.php");
?>
<!doctype html>
<html>
<head>
<meta charset="UTF-8">
<title>View Projects - Transparent Quantities</title>
<style>
body {
  background: #99b4d1;
  font-family: Arial, sans-serif;
  margin: 0;
  padding: 20px;
  color: #222;
}

.project-header {
  font-weight: bold;
  margin-bottom: 12px;
  font-size: 16px;
  color: #fff;
  text-align: center;
}

/* Scrollable container */
.projects-scroll-container {
  height: 450px;
  overflow-y: auto;
  overflow-x: hidden;
  border: 1px solid #ddd;
  border-radius: 6px;
  background: #f4f6f9;
  scroll-behavior: smooth;
}

/* Light scrollbar styling */
.projects-scroll-container::-webkit-scrollbar {
  width: 10px;
}
.projects-scroll-container::-webkit-scrollbar-track {
  background: #e6e9ed;
  border-radius: 10px;
}
.projects-scroll-container::-webkit-scrollbar-thumb {
  background-color: #bbb;
  border-radius: 10px;
  border: 2px solid #e6e9ed;
}
.projects-scroll-container::-webkit-scrollbar-thumb:hover {
  background-color: #999;
}

/* Table styling */
.projects-table {
  width: 100%;
  border-collapse: collapse;
  font-size: 13px;
  color: #222;
}

/* Fixed header */
.projects-table thead {
  position: sticky;
  top: 0;
  z-index: 2;
  background: #fff;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* Table cells */
.projects-table th, .projects-table td {
  padding: 8px 10px;
  text-align: left;
  border-bottom: 1px solid #ddd;
}

.projects-table th {
  background: #fff;
  color: #000;
  font-weight: 600;
}

.projects-table tbody tr:nth-child(even) {
  background: #f9fafb;
}
.projects-table tbody tr:nth-child(odd) {
  background: #fff;
}

/* Clickable rows */
.clickable-row {
  cursor: pointer;
  transition: background 0.2s, color 0.2s;
}
.clickable-row:hover {
  background: #e8f0fe !important;
  color: #003366;
}
</style>
</head>
<body>

<div class="project-header">All Created Projects</div>

<div class="projects-scroll-container">
  <table class="projects-table">
    <thead>
      <tr>
        <th>Project Ref</th>
        <th>Type</th>
        <th>Name</th>
        <th>Developer</th>
        <th>Address</th>
        <th>Date Added</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $sql = "SELECT project_ref, project_type, project_name, project_developer, project_address, date_added 
              FROM upline_app_project_info 
              ORDER BY date_added DESC";
      $result = $con->query($sql);

      if (!$result) {
          die('SQL Error: ' . $con->error);
      }

      if ($result->num_rows > 0) {
          while($row = $result->fetch_assoc()) {
              $ref = htmlspecialchars($row['project_ref']);
              echo "<tr class='clickable-row' data-href=\"project_detail.php?project_ref={$ref}\">
                      <td>{$ref}</td>
                      <td>".htmlspecialchars($row['project_type'])."</td>
                      <td>".htmlspecialchars($row['project_name'])."</td>
                      <td>".htmlspecialchars($row['project_developer'])."</td>
                      <td>".htmlspecialchars($row['project_address'])."</td>
                      <td>".htmlspecialchars($row['date_added'])."</td>
                    </tr>";
          }
      } else {
          echo '<tr><td colspan="6" style="text-align:center;">No projects found</td></tr>';
      }
      ?>
    </tbody>
  </table>
</div>

<script>
// Make table rows clickable
document.querySelectorAll(".clickable-row").forEach(row => {
  row.addEventListener("click", () => {
    if (window.parent && window.parent.openModal) {
      window.parent.openModal(row.dataset.href);
    } else {
      window.location.href = row.dataset.href;
    }
  });
});
</script>

</body>
</html>
