<?php
ini_set('display_errors',1);
session_start();
include('script/condb.php');
include('script/uom_converter.php'); // <-- must exist and provide convertUOM($value,$from,$to)

$PID = $_GET['xd'] ?? $_POST['PID'] ?? null;

// Get project default UOM
$projQuery = mysqli_query($con, "SELECT default_uom FROM upline_app_project_info WHERE id='$PID'");
$projData = mysqli_fetch_assoc($projQuery);
$projectUOM = $projData['default_uom'] ?? 'm'; // fallback to meters

// Debug flag: append &debug=true to URL to preview conversions and skip DB inserts
$DEBUG_MODE = isset($_GET['debug']) && $_GET['debug'] === 'true';

if (isset($_POST["check1"])) {

    //------------------------9"-------------------------------------------
    $is44 = "SELECT * FROM upline_app_blocksettings WHERE ID='2'";
    $ise44 = mysqli_query($con, $is44);
    while ($rec44 = mysqli_fetch_array($ise44)) {
        $blockame = $rec44['Block_name']; 
        $labourprice = $rec44['Up_Labours'];
    }

    //------------------------6"-------------------------------------------
    $is45 = "SELECT * FROM upline_app_blocksettings WHERE ID='4'";
    $ise45 = mysqli_query($con, $is45);
    while ($rec45 = mysqli_fetch_array($ise45)) {
        $blockame6 = $rec45['Block_name']; 
        $labourprice6 = $rec45['Up_Labours'];
    }

    //------------------------5"-------------------------------------------
    $is46 = "SELECT * FROM upline_app_blocksettings WHERE ID='5'";
    $ise46 = mysqli_query($con, $is46);
    while ($rec46 = mysqli_fetch_array($ise46)) {
        $blockame5 = $rec46['Block_name']; 
        $labourprice5 = $rec46['Up_Labours'];
    }

    //------------------------4"-------------------------------------------
    $is47 = "SELECT * FROM upline_app_blocksettings WHERE ID='6'";
    $ise47 = mysqli_query($con, $is47);
    while ($rec47 = mysqli_fetch_array($ise47)) {
        $blockame4 = $rec47['Block_name']; 
        $labourprice4 = $rec47['Up_Labours'];
    }

    // Capture form values (ASSUMED INPUTS ARE IN METERS)
    $A_3 = $_POST['extwalls'];
    $blocktype1 = $_POST['ddselect'];
    $A_5 = $_POST['length'];        // length (meters)
    $A_11 = $_POST['course'];
    $A_7 = $_POST['height'];        // height (meters)
    $A_3A = $_POST['intwalls'];
    $A_6A = $_POST['length2'];      // internal length (meters)
    $A_12A = $_POST['course2'];
    $A_8A = $_POST['height2'];      // internal height (meters)
    $otherwalls = $_POST['otherwalls'];
    $A_6 = $_POST['length3'];       // other wall length (meters)
    $A_12 = $_POST['course3'];
    $A_8 = $_POST['height3'];       // other wall height (meters)
    $blocktype2 = $_POST['amigo'];
    $blocktype3 = $_POST['amadi'];

    // Keep the original calculation logic (uses meters as base unit)
    $M36 = 0.11875;
    $A_NH_1 = 0.25;
    $A_NH_5 = 0.11875;
    $inblck9 = 400;
    $inblck6 = 350;
    $inblck5 = 320;
    $inblck4 = 350;
    $unitprice = '';
    $unitprice1 = '';
    $unitprice2 = '';
    $blocktype1a = 'Laying of ' . $blocktype1;
    $blocktype2a = 'Laying of ' . $blocktype2;
    $blocktype3a = 'Laying of ' . $blocktype3;

    //--------------------unit price------------------
    if ($blocktype1 == '9 inches Hollow Block') {
        $unitprice = $inblck9;
    } elseif ($blocktype1 == '6 inches Solid Block' || $blocktype1 == '6 inches Hollow Block') {
        $unitprice = $inblck6;
    } elseif ($blocktype1 == '5 inches Solid Block') {
        $unitprice = $inblck5;
    } elseif ($blocktype1 == '4 inches Hollow Block') {
        $unitprice = $inblck4;
    }

    //------------two-------------
    if ($blocktype2 == '9 inches Hollow Block') {
        $unitprice1 = $inblck9;
    } elseif ($blocktype2 == '6 inches Solid Block' || $blocktype1 == '6 inches Hollow Block') {
        $unitprice1 = $inblck6;
    } elseif ($blocktype2 == '5 inches Solid Block') {
        $unitprice1 = $inblck5;
    } elseif ($blocktype2 == '4 inches Hollow Block') {
        $unitprice1 = $inblck4;
    }

    //------------three-------------
    if ($blocktype3 == '9 inches Hollow Block') {
        $unitprice2 = $inblck9;
    } elseif ($blocktype3 == '6 inches Solid Block' || $blocktype1 == '6 inches Hollow Block') {
        $unitprice2 = $inblck6;
    } elseif ($blocktype3 == '5 inches Solid Block') {
        $unitprice2 = $inblck5;
    } elseif ($blocktype3 == '4 inches Hollow Block') {
        $unitprice2 = $inblck4;
    }

    //-----------------external wall calculations----------------------
    $hl = $A_5 * $A_7;
    $hl2 = $hl / $M36;
    $extrwallcal = $hl2;
    $coeextrwallcal2 = number_format($extrwallcal, 0);

    $boqextrwallcal = number_format($A_5 * $A_7, 0);
    if ($blocktype1 == '9 inches Hollow Block') {
        $totalblockCOE = $coeextrwallcal2 * $inblck9;
        $totalblockBOQ = $boqextrwallcal * $inblck9;
        $coelabourtotal = $labourprice * $coeextrwallcal2;
        $boqlabourtotal = $labourprice * $boqextrwallcal;
    } elseif ($blocktype1 == '6 inches Solid Block' || $blocktype1 == '6 inches Hollow Block') {
        $totalblockCOE = $coeextrwallcal2 * $inblck6;
        $totalblockBOQ = $boqextrwallcal * $inblck6;
        $coelabourtotal = $labourprice5 * $coeextrwallcal2;
        $boqlabourtotal = $labourprice5 * $boqextrwallcal2;
    } elseif ($blocktype1 == '5 inches Solid Block') {
        $totalblockCOE = $coeextrwallcal2 * $inblck5;
        $totalblockBOQ = $boqextrwallcal * $inblck5;
        $coelabourtotal = $coeextrwallcal2 * $labourprice5;
        $boqlabourtotal = $boqextrwallcal * $labourprice5;
    } elseif ($blocktype1 == '4 inches Hollow Block') {
        $totalblockCOE = $coeextrwallcal2 * $inblck4;
        $totalblockBOQ = $boqextrwallcal * $inblck4;
        $coelabourtotal = $labourprice4 * $coeextrwallcal2;
        $boqlabourtotal = $labourprice4 * $boqextrwallcal;
    }

    //-----------------internal wall calculations----------------------
    $hlin = $A_6A * $A_8A;
    $hlin2 = $hlin / $M36;
    $intwallcal = number_format($hlin2, 0);
    $boqintwallcal = number_format($A_6A * $A_8A, 0);

    if ($blocktype2 == '9 inches Hollow Block') {
        $totalblockCOE1 = $intwallcal * $inblck9;
        $totalblockBOQ1 = $boqintwallcal * $inblck9;
        $coelabourtotal = $labourprice * $intwallcal;
        $boqlabourtotal = $labourprice * $boqintwallcal;
    } elseif ($blocktype2 == '6 inches Solid Block' || $blocktype2 == '6 inches Hollow Block') {
        $totalblockCOE1 = $intwallcal * $inblck6;
        $totalblockBOQ1 = $boqintwallcal * $inblck6;
        $coelabourtotal1 = $labourprice5 * $intwallcal;
        $boqlabourtotal1 = $labourprice5 * $boqintwallcal;
    } elseif ($blocktype2 == '5 inches Solid Block') {
        $totalblockCOE1 = $intwallcal * $inblck5;
        $totalblockBOQ1 = $boqintwallcal * $inblck5;
        $coelabourtotal1 = $intwallcal * $labourprice5;
        $boqlabourtotal1 = $boqintwallcal * $labourprice5;
    } elseif ($blocktype2 == '4 inches Hollow Block') {
        $totalblockCOE = $intwallcal * $inblck4;
        $totalblockBOQ = $boqintwallcal * $inblck4;
        $coelabourtotal1 = $labourprice4 * $intwallcal;
        $boqlabourtotal1 = $labourprice4 * $boqintwallcal;
    }

    //-----------------other wall calculations----------------------
    $hloth = $A_6 * $A_8;
    $hloth2 = $hloth / $M36;
    $othwallcal = number_format($hloth2, 0);
    $boqothwallcal = number_format($A_6 * $A_8, 0);

    if ($blocktype3 == '9 inches Hollow Block') {
        $totalblockCOE2 = $othwallcal * $inblck9;
        $totalblockBOQ2 = $boqothwallcal * $inblck9;
        $coelabourtotal2 = $labourprice * $othwallcal;
        $boqlabourtotal2 = $labourprice * $boqothwallcal;
    } elseif ($blocktype3 == '6 inches Solid Block' || $blocktype3 == '6 inches Hollow Block') {
        $totalblockCOE2 = $othwallcal * $inblck6;
        $totalblockBOQ2 = $boqothwallcal * $inblck6;
        $coelabourtotal2 = $labourprice5 * $othwallcal;
        $boqlabourtotal2 = $labourprice5 * $boqothwallcal;
    } elseif ($blocktype3 == '5 inches Solid Block') {
        $totalblockCOE2 = $othwallcal * $inblck5;
        $totalblockBOQ2 = $boqothwallcal * $inblck5;
        $coelabourtotal2 = $othwallcal * $labourprice5;
        $boqlabourtotal2 = $boqothwallcal * $labourprice5;
    } elseif ($blocktype3 == '4 inches Hollow Block') {
        $totalblockCOE2 = $othwallcal * $inblck4;
        $totalblockBOQ2 = $boqothwallcal * $inblck4;
        $coelabourtotal2 = $labourprice4 * $othwallcal;
        $boqlabourtotal2 = $labourprice4 * $boqothwallcal;
    }

    // BEFORE inserting to wall_calculation we convert lengths to project default UOM
    // (calculations were done using meters as base)
    $ins_A5  = convertUOM($A_5, 'm', $projectUOM);
    $ins_A7  = convertUOM($A_7, 'm', $projectUOM);
    $ins_A6A = convertUOM($A_6A, 'm', $projectUOM);
    $ins_A8A = convertUOM($A_8A, 'm', $projectUOM);
    $ins_A6  = convertUOM($A_6, 'm', $projectUOM);
    $ins_A8  = convertUOM($A_8, 'm', $projectUOM);

    // DEBUG mode: show original (meters) and converted values; skip DB inserts
    if ($DEBUG_MODE) {
        echo "<h2>🔎 DEBUG MODE: Conversion Preview for Project #$PID</h2>";
        echo "<p><strong>Project Default UOM:</strong> $projectUOM</p>";

        echo "<h3>External Wall</h3>";
        echo "<p>Original Length (meters): {$_POST['length']} → Converted: $ins_A5 $projectUOM</p>";
        echo "<p>Original Height (meters): {$_POST['height']} → Converted: $ins_A7 $projectUOM</p>";

        echo "<h3>Internal Wall</h3>";
        echo "<p>Original Length (meters): {$_POST['length2']} → Converted: $ins_A6A $projectUOM</p>";
        echo "<p>Original Height (meters): {$_POST['height2']} → Converted: $ins_A8A $projectUOM</p>";

        echo "<h3>Other Wall</h3>";
        echo "<p>Original Length (meters): {$_POST['length3']} → Converted: $ins_A6 $projectUOM</p>";
        echo "<p>Original Height (meters): {$_POST['height3']} → Converted: $ins_A8 $projectUOM</p>";

        echo "<hr><h3>Calculation Results (unchanged, computed in meters)</h3>";
        echo "<p>COE External Wall Quantity (blocks): $coeextrwallcal2</p>";
        echo "<p>COE Internal Wall Quantity (blocks): $intwallcal</p>";
        echo "<p>COE Other Wall Quantity (blocks): $othwallcal</p>";

        echo "<p style='color:red'><strong>NOTE:</strong> Debug mode is ON — no database records were inserted.</p>";
        exit;
    }

    // ---------- Insert into wall_calculation with converted lengths ----------
    $inst2 = "INSERT INTO wall_calculation (PID, walltype, blocktype, walllength, wallheight, Course) VALUES
    ('$PID', '$A_3', '$blocktype1', '$ins_A5', '$ins_A7', '$A_11'),
    ('$PID', '$A_3A', '$blocktype2', '$ins_A6A', '$ins_A8A', '$A_12A'),
    ('$PID', '$otherwalls', '$blocktype3', '$ins_A6', '$ins_A8', '$A_12')";
    mysqli_query($con, $inst2);

    // ---------- Insert labour (unchanged) ----------
    $fl = "INSERT INTO foundation_labourer (PID, LabourerDescription, COEQuantity, BOQQuantity, Extra, Price, COETotal, BOQTotal) VALUES
    ('$PID', '$blocktype1a', '$coeextrwallcal2', '$boqextrwallcal', '0', '$labourprice', '$coelabourtotal', '$boqlabourtotal'),
    ('$PID', '$blocktype2a', '$intwallcal', '$boqintwallcal', '0', '$labourprice', '$coelabourtotal1', '$boqlabourtotal1'),
    ('$PID', '$blocktype3a', '$othwallcal', '$boqothwallcal', '0', '$labourprice', '$coelabourtotal2', '$boqlabourtotal2')";
    mysqli_query($con, $fl);

    // ---------- Insert materials (unchanged - these are counts & totals) ----------
    $inst = "INSERT INTO foundation_materials (PID, MaterialDescription, COEQuantity, BOQQuantity, Extra, Price, CETotalAmount, BOQTotalAmount) VALUES
    ('$PID', '$blocktype1', '$coeextrwallcal2', '$boqextrwallcal', '0', '$unitprice', '$totalblockCOE', '$totalblockBOQ'),
    ('$PID', '$blocktype2', '$intwallcal', '$boqintwallcal', '0', '$unitprice1', '$totalblockCOE1', '$totalblockBOQ1'),
    ('$PID', '$blocktype3', '$othwallcal', '$boqothwallcal', '0', '$unitprice2', '$totalblockCOE2', '$totalblockBOQ2')";
    $checkmate = mysqli_query($con, $inst);

    if ($checkmate) {
        header("Location: stagesofproject.php?id=$PID");
        exit;
    }
}
?>
