<?php
// ======================================================
// Extension of FPDF to add transparency (alpha channel)
// Save this file as: fpdf_alpha.php
// ======================================================

require_once __DIR__ . '/fpdf.php';

class FPDF_ALPHA extends FPDF
{
    protected $extgstates = [];

    function SetAlpha($alpha, $bm = 'Normal')
    {
        // Set transparency for PDF graphics
        if ($alpha < 0) $alpha = 0;
        if ($alpha > 1) $alpha = 1;

        $gs = $this->_addExtGState(['ca' => $alpha, 'CA' => $alpha, 'BM' => '/' . $bm]);
        $this->_setExtGState($gs);
    }

    protected function _addExtGState($parms)
    {
        $n = count($this->extgstates) + 1;
        $this->extgstates[$n]['parms'] = $parms;
        return $n;
    }

    protected function _setExtGState($gs)
    {
        $this->_out(sprintf('/GS%d gs', $gs));
    }

    function _enddoc()
    {
        if (!empty($this->extgstates) && $this->PDFVersion < '1.4')
            $this->PDFVersion = '1.4';
        parent::_enddoc();
    }

    function _putextgstates()
    {
        foreach ($this->extgstates as $k => $extgstate) {
            $this->_newobj();
            $this->extgstates[$k]['n'] = $this->n;
            $this->_out('<< /Type /ExtGState');
            $parms = $extgstate['parms'];
            $this->_out(sprintf('/ca %.3F', $parms['ca']));
            $this->_out(sprintf('/CA %.3F', $parms['CA']));
            $this->_out('/BM ' . $parms['BM']);
            $this->_out('>>');
            $this->_out('endobj');
        }
    }

    function _putresourcedict()
    {
        parent::_putresourcedict();
        if (!empty($this->extgstates)) {
            $this->_out('/ExtGState <<');
            foreach ($this->extgstates as $k => $extgstate) {
                $this->_out('/GS' . $k . ' ' . $extgstate['n'] . ' 0 R');
            }
            $this->_out('>>');
        }
    }

    function _putresources()
    {
        $this->_putextgstates();
        parent::_putresources();
    }
}
