<?php
// project_detail.php
session_start();
include('script/condb.php');

// basic validation
if (!isset($_GET['project_ref']) || empty($_GET['project_ref'])) {
    exit('No project reference provided.');
}

$project_ref = mysqli_real_escape_string($con, $_GET['project_ref']);

// fetch the project
$sql = "SELECT * FROM upline_app_project_info WHERE project_ref = '$project_ref' LIMIT 1";
$result = $con->query($sql);

if (!$result || $result->num_rows === 0) {
    exit('No project found with that reference.');
}

$row = $result->fetch_assoc();

// friendly labels mapping (use array() for max compatibility)
$labels = array(
    "project_ref"        => "Project Reference",
    "project_name"       => "Project Name",
    "project_type"       => "Project Type",
    "project_developer"  => "Project Developer",
    "project_location"   => "Project Location",
    "project_status"     => "Project Status",
    "date_added"         => "Date Added",
    "last_updated"       => "Last Updated",
    "created_by"         => "Created By",
    "approved_by"        => "Approved By",
    "budget"             => "Estimated Budget",
    "remarks"            => "Remarks / Notes"
);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Project Details - <?php echo htmlspecialchars($row['project_ref']); ?></title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <style>
    body { font-family: Arial, sans-serif; margin:0; padding:40px; background:#f4f6f9; color:#333; }
    .container { max-width:1100px; margin:0 auto; display:flex; gap:20px; flex-wrap:wrap; }
    .summary-box { flex:1; min-width:80%; background:#99b4d1; padding:20px; border:1px solid #ddd; border-radius:6px; text-align:left; box-shadow:0 2px 5px rgba(0,0,0,0.06); }
    .summary-box h2 { margin:0 0 10px; font-size:22px; color:#0073e6; font-weight: 700;}
    .summary-box p { margin:6px 0; font-size:14px; }
    .details-box { flex:2; min-width:80%; background:#99b4d1; padding:20px; border:1px solid #ddd; border-radius:6px; box-shadow:0 2px 5px rgba(0,0,0,0.06); }
    .details-box h3 { text-align:left; margin:0 0 15px; font-weight: 300;font-size: 18px; }
    .details-table { width:100%; border-collapse:collapse; }
    .details-table th, .details-table td {padding:8px 12px; text-align:left; font-size:14px; vertical-align:top; }
    .details-table th {width:30%;}
    .back-link { display:block; text-align:right; text-decoration:none; color:#0073e6; font-size:14px;}
    .back-link:hover { text-decoration:underline; }
    /* small screens */
    @media (max-width:760px){
      .container { padding:10px; }
      .details-box, .summary-box { min-width:100%; }
    }
	  .project-summary {
    display: flex;
    flex-direction: column;
    justify-content: space-between; /* pushes buttons to bottom */
    height: 100%;  /* takes full height of card */
}

.project-actions {
    margin-top: auto;   /* forces buttons to bottom */
    text-align: left;
    padding-top: 15px;
}

.btn-action {
    display: inline-block;
    margin: 0 0px;
    padding: 10px 18px;
    background: #007bff;
    color: #fff;
    border-radius: 5px;
    font-size: 14px;
    text-decoration: none;
    transition: background 0.2s ease;
}
.btn-action:hover {
    opacity: 0.7;
	font-weight: 700;
}
.btn-action2 {
    display: inline-block;
    margin: 0 0px;
    padding: 10px 18px;
    background: #7d4140;
    color: #fff;
    border-radius: 5px;
    font-size: 14px;
    text-decoration: none;
    transition: background 0.2s ease;
}
.btn-action2:hover {
    opacity: 0.7;
	font-weight: 700;
}
    .back-link-wrapper { 
		width: 80.5%;
		margin: 0 auto;
		padding: 16px 32px;
	  }

  </style>
</head>
<body>
<div class="back-link-wrapper">
<a href="lander.php" class="back-link">&larr; Back to Projects</a>
</div>
  <div class="container">
    <!-- summary -->
    <div class="summary-box">
      <h2><?php echo htmlspecialchars($row['project_name'] ?: $row['project_ref']); ?></h2>
      <p>Project Reference:<?php echo htmlspecialchars($row['project_ref']); ?></p>
      <p>Project Type:<?php echo htmlspecialchars($row['project_type']); ?></p>
      <?php if (!empty($row['project_developer'])): ?>
        <p>Developer:<?php echo htmlspecialchars($row['project_developer']); ?></p>
      <?php endif; ?>
      <?php if (!empty($row['project_location'])): ?>
        <p>Location:<?php echo htmlspecialchars($row['project_location']); ?></p>
      <?php endif; ?>
      <p>Date Added:<?php echo htmlspecialchars($row['date_added']); ?></p>
		
		<!-- Action buttons -->
    <div class="project-actions">
        <a href="foundation21.php?project_ref=<?php echo urlencode($row['project_ref']); ?>" class="btn-action">Create Cost Estimate</a>
        <a href="foundation_report_boq_main.php?project_ref=<?php echo urlencode($row['project_ref']); ?>" class="btn-action2">Create BOQ</a>
    </div>
		
    </div>

    <!-- details -->
    <div class="details-box">
      <p>Full Project Record</p>
      <table class="details-table" role="table">
        <tbody>
          <?php
          // print each field (hide internal id if present)
          foreach ($row as $field => $value) {
              if ($field === 'id') continue; // skip internal id
              $label = isset($labels[$field]) ? $labels[$field] : ucwords(str_replace('_', ' ', $field));
              // show empty values as dash for better readability
              $display = ($value === null || $value === '') ? '—' : htmlspecialchars($value);
              echo "<tr>\n";
              echo "  <th>" . htmlspecialchars($label) . "</th>\n";
              echo "  <td>" . $display . "</td>\n";
              echo "</tr>\n";
          }
          ?>
        </tbody>
      </table>
    </div>
  </div>

  

</body>
</html>
